/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a single document style to insert.")
public class StyleInsert
implements ModelIfc {
    @SerializedName(value="StyleName")
    protected String styleName = null;
    @SerializedName(value="StyleType")
    protected StyleTypeEnum styleType = null;

    @ApiModelProperty(value="Gets or sets the case sensitive name of the style to create.")
    public String getStyleName() {
        return this.styleName;
    }

    public StyleInsert styleName(String styleName) {
        this.styleName = styleName;
        return this;
    }

    public void setStyleName(String styleName) {
        this.styleName = styleName;
    }

    @ApiModelProperty(value="Gets or sets the StyleType value that specifies the type of the style to create.")
    public StyleTypeEnum getStyleType() {
        return this.styleType;
    }

    public StyleInsert styleType(StyleTypeEnum styleType) {
        this.styleType = styleType;
        return this;
    }

    public void setStyleType(StyleTypeEnum styleType) {
        this.styleType = styleType;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.styleName == null) {
            throw new ApiException(400, "Property StyleName in StyleInsert is required.");
        }
        if (this.styleType == null) {
            throw new ApiException(400, "Property StyleType in StyleInsert is required.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StyleInsert styleInsert = (StyleInsert)o;
        return Objects.equals(this.styleName, styleInsert.styleName) && Objects.equals((Object)this.styleType, (Object)styleInsert.styleType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.styleName, this.styleType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StyleInsert {\n");
        sb.append("    styleName: ").append(this.toIndentedString(this.getStyleName())).append("\n");
        sb.append("    styleType: ").append(this.toIndentedString((Object)this.getStyleType())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StyleTypeEnum {
        PARAGRAPH("Paragraph"),
        CHARACTER("Character"),
        TABLE("Table"),
        LIST("List");

        private String value;

        private StyleTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StyleTypeEnum fromValue(String text) {
            for (StyleTypeEnum b : StyleTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StyleTypeEnum> {
            public void write(JsonWriter jsonWriter, StyleTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StyleTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StyleTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

