/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a single document style properties to update.")
public class StyleUpdate
implements ModelIfc {
    @SerializedName(value="NextParagraphStyleName")
    protected String nextParagraphStyleName = null;
    @SerializedName(value="BaseStyleName")
    protected String baseStyleName = null;
    @SerializedName(value="IsQuickStyle")
    protected Boolean isQuickStyle = null;
    @SerializedName(value="Name")
    protected String name = null;

    @ApiModelProperty(value="Gets or sets the name of the style to be applied automatically to a new paragraph inserted after a paragraph formatted with the specified style. This property is not used by Aspose.Words. The next paragraph style will only be applied automatically when you edit the document in MS Word.")
    public String getNextParagraphStyleName() {
        return this.nextParagraphStyleName;
    }

    public StyleUpdate nextParagraphStyleName(String nextParagraphStyleName) {
        this.nextParagraphStyleName = nextParagraphStyleName;
        return this;
    }

    public void setNextParagraphStyleName(String nextParagraphStyleName) {
        this.nextParagraphStyleName = nextParagraphStyleName;
    }

    @ApiModelProperty(value="Gets or sets the name of the style this style is based on. This will be an empty string if the style is not based on any other style and it can be set to an empty string.")
    public String getBaseStyleName() {
        return this.baseStyleName;
    }

    public StyleUpdate baseStyleName(String baseStyleName) {
        this.baseStyleName = baseStyleName;
        return this;
    }

    public void setBaseStyleName(String baseStyleName) {
        this.baseStyleName = baseStyleName;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether this style is shown in the Quick Style gallery inside MS Word UI.")
    public Boolean getIsQuickStyle() {
        return this.isQuickStyle;
    }

    public StyleUpdate isQuickStyle(Boolean isQuickStyle) {
        this.isQuickStyle = isQuickStyle;
        return this;
    }

    public void setIsQuickStyle(Boolean isQuickStyle) {
        this.isQuickStyle = isQuickStyle;
    }

    @ApiModelProperty(value="Gets or sets the name of the style. Cannot be an empty string. If there already is a style with such name in the collection, than this style will override it. All affected nodes will reference new style.")
    public String getName() {
        return this.name;
    }

    public StyleUpdate name(String name) {
        this.name = name;
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StyleUpdate styleUpdate = (StyleUpdate)o;
        return Objects.equals(this.nextParagraphStyleName, styleUpdate.nextParagraphStyleName) && Objects.equals(this.baseStyleName, styleUpdate.baseStyleName) && Objects.equals(this.isQuickStyle, styleUpdate.isQuickStyle) && Objects.equals(this.name, styleUpdate.name);
    }

    public int hashCode() {
        return Objects.hash(this.nextParagraphStyleName, this.baseStyleName, this.isQuickStyle, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StyleUpdate {\n");
        sb.append("    nextParagraphStyleName: ").append(this.toIndentedString(this.getNextParagraphStyleName())).append("\n");
        sb.append("    baseStyleName: ").append(this.toIndentedString(this.getBaseStyleName())).append("\n");
        sb.append("    isQuickStyle: ").append(this.toIndentedString(this.getIsQuickStyle())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.getName())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

