/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.FixedPageSaveOptionsData;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for svg save options.")
public class SvgSaveOptionsData
extends FixedPageSaveOptionsData {
    @SerializedName(value="ExportEmbeddedImages")
    protected Boolean exportEmbeddedImages = null;
    @SerializedName(value="FitToViewPort")
    protected Boolean fitToViewPort = null;
    @SerializedName(value="IdPrefix")
    protected String idPrefix = null;
    @SerializedName(value="MaxImageResolution")
    protected Integer maxImageResolution = null;
    @SerializedName(value="ResourcesFolder")
    protected String resourcesFolder = null;
    @SerializedName(value="ResourcesFolderAlias")
    protected String resourcesFolderAlias = null;
    @SerializedName(value="ShowPageBorder")
    protected Boolean showPageBorder = null;
    @SerializedName(value="TextOutputMode")
    protected TextOutputModeEnum textOutputMode = null;

    @ApiModelProperty(value="Gets or sets a value indicating whether images should be embedded into SVG document as base64.")
    public Boolean getExportEmbeddedImages() {
        return this.exportEmbeddedImages;
    }

    public SvgSaveOptionsData exportEmbeddedImages(Boolean exportEmbeddedImages) {
        this.exportEmbeddedImages = exportEmbeddedImages;
        return this;
    }

    public void setExportEmbeddedImages(Boolean exportEmbeddedImages) {
        this.exportEmbeddedImages = exportEmbeddedImages;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the output SVG should fill the available viewport area (browser window or container). When set to true width and height of output SVG are set to 100%.")
    public Boolean getFitToViewPort() {
        return this.fitToViewPort;
    }

    public SvgSaveOptionsData fitToViewPort(Boolean fitToViewPort) {
        this.fitToViewPort = fitToViewPort;
        return this;
    }

    public void setFitToViewPort(Boolean fitToViewPort) {
        this.fitToViewPort = fitToViewPort;
    }

    @ApiModelProperty(value="Gets or sets specifies a prefix that is prepended to all generated element IDs in the output document. The default value is null and no prefix is prepended. If the prefix is specified, it can contain only letters, digits, underscores, and hyphens, and must start with a letter.")
    public String getIdPrefix() {
        return this.idPrefix;
    }

    public SvgSaveOptionsData idPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
        return this;
    }

    public void setIdPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
    }

    @ApiModelProperty(value="Gets or sets a value in pixels per inch that limits resolution of exported raster images. If the value of this property is non-zero, it limits resolution of exported raster images. That is, higher-resolution images are resampled down to the limit and lower-resolution images are exported as is.")
    public Integer getMaxImageResolution() {
        return this.maxImageResolution;
    }

    public SvgSaveOptionsData maxImageResolution(Integer maxImageResolution) {
        this.maxImageResolution = maxImageResolution;
        return this;
    }

    public void setMaxImageResolution(Integer maxImageResolution) {
        this.maxImageResolution = maxImageResolution;
    }

    @ApiModelProperty(value="Gets or sets the physical folder where resources (images) are saved when exporting.")
    public String getResourcesFolder() {
        return this.resourcesFolder;
    }

    public SvgSaveOptionsData resourcesFolder(String resourcesFolder) {
        this.resourcesFolder = resourcesFolder;
        return this;
    }

    public void setResourcesFolder(String resourcesFolder) {
        this.resourcesFolder = resourcesFolder;
    }

    @ApiModelProperty(value="Gets or sets the name of the folder used to construct image URIs.")
    public String getResourcesFolderAlias() {
        return this.resourcesFolderAlias;
    }

    public SvgSaveOptionsData resourcesFolderAlias(String resourcesFolderAlias) {
        this.resourcesFolderAlias = resourcesFolderAlias;
        return this;
    }

    public void setResourcesFolderAlias(String resourcesFolderAlias) {
        this.resourcesFolderAlias = resourcesFolderAlias;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to show or hide page stepper.")
    public Boolean getShowPageBorder() {
        return this.showPageBorder;
    }

    public SvgSaveOptionsData showPageBorder(Boolean showPageBorder) {
        this.showPageBorder = showPageBorder;
        return this;
    }

    public void setShowPageBorder(Boolean showPageBorder) {
        this.showPageBorder = showPageBorder;
    }

    @ApiModelProperty(value="Gets or sets the option that controls how text should be rendered.")
    public TextOutputModeEnum getTextOutputMode() {
        return this.textOutputMode;
    }

    public SvgSaveOptionsData textOutputMode(TextOutputModeEnum textOutputMode) {
        this.textOutputMode = textOutputMode;
        return this;
    }

    public void setTextOutputMode(TextOutputModeEnum textOutputMode) {
        this.textOutputMode = textOutputMode;
    }

    public SvgSaveOptionsData() {
        this.saveFormat = "svg";
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvgSaveOptionsData svgSaveOptionsData = (SvgSaveOptionsData)o;
        return Objects.equals(this.exportEmbeddedImages, svgSaveOptionsData.exportEmbeddedImages) && Objects.equals(this.fitToViewPort, svgSaveOptionsData.fitToViewPort) && Objects.equals(this.idPrefix, svgSaveOptionsData.idPrefix) && Objects.equals(this.maxImageResolution, svgSaveOptionsData.maxImageResolution) && Objects.equals(this.resourcesFolder, svgSaveOptionsData.resourcesFolder) && Objects.equals(this.resourcesFolderAlias, svgSaveOptionsData.resourcesFolderAlias) && Objects.equals(this.showPageBorder, svgSaveOptionsData.showPageBorder) && Objects.equals((Object)this.textOutputMode, (Object)svgSaveOptionsData.textOutputMode) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.exportEmbeddedImages, this.fitToViewPort, this.idPrefix, this.maxImageResolution, this.resourcesFolder, this.resourcesFolderAlias, this.showPageBorder, this.textOutputMode, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SvgSaveOptionsData {\n");
        sb.append("    allowEmbeddingPostScriptFonts: ").append(this.toIndentedString(this.getAllowEmbeddingPostScriptFonts())).append("\n");
        sb.append("    customTimeZoneInfoData: ").append(this.toIndentedString(this.getCustomTimeZoneInfoData())).append("\n");
        sb.append("    dml3DEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDml3DEffectsRenderingMode())).append("\n");
        sb.append("    dmlEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDmlEffectsRenderingMode())).append("\n");
        sb.append("    dmlRenderingMode: ").append(this.toIndentedString((Object)this.getDmlRenderingMode())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    imlRenderingMode: ").append(this.toIndentedString((Object)this.getImlRenderingMode())).append("\n");
        sb.append("    updateAmbiguousTextFont: ").append(this.toIndentedString(this.getUpdateAmbiguousTextFont())).append("\n");
        sb.append("    updateCreatedTimeProperty: ").append(this.toIndentedString(this.getUpdateCreatedTimeProperty())).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.getUpdateFields())).append("\n");
        sb.append("    updateLastPrintedProperty: ").append(this.toIndentedString(this.getUpdateLastPrintedProperty())).append("\n");
        sb.append("    updateLastSavedTimeProperty: ").append(this.toIndentedString(this.getUpdateLastSavedTimeProperty())).append("\n");
        sb.append("    zipOutput: ").append(this.toIndentedString(this.getZipOutput())).append("\n");
        sb.append("    colorMode: ").append(this.toIndentedString((Object)this.getColorMode())).append("\n");
        sb.append("    jpegQuality: ").append(this.toIndentedString(this.getJpegQuality())).append("\n");
        sb.append("    metafileRenderingOptions: ").append(this.toIndentedString(this.getMetafileRenderingOptions())).append("\n");
        sb.append("    numeralFormat: ").append(this.toIndentedString((Object)this.getNumeralFormat())).append("\n");
        sb.append("    optimizeOutput: ").append(this.toIndentedString(this.getOptimizeOutput())).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.getPageCount())).append("\n");
        sb.append("    pageIndex: ").append(this.toIndentedString(this.getPageIndex())).append("\n");
        sb.append("    exportEmbeddedImages: ").append(this.toIndentedString(this.getExportEmbeddedImages())).append("\n");
        sb.append("    fitToViewPort: ").append(this.toIndentedString(this.getFitToViewPort())).append("\n");
        sb.append("    idPrefix: ").append(this.toIndentedString(this.getIdPrefix())).append("\n");
        sb.append("    maxImageResolution: ").append(this.toIndentedString(this.getMaxImageResolution())).append("\n");
        sb.append("    resourcesFolder: ").append(this.toIndentedString(this.getResourcesFolder())).append("\n");
        sb.append("    resourcesFolderAlias: ").append(this.toIndentedString(this.getResourcesFolderAlias())).append("\n");
        sb.append("    showPageBorder: ").append(this.toIndentedString(this.getShowPageBorder())).append("\n");
        sb.append("    textOutputMode: ").append(this.toIndentedString((Object)this.getTextOutputMode())).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.getSaveFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TextOutputModeEnum {
        USESVGFONTS("UseSvgFonts"),
        USETARGETMACHINEFONTS("UseTargetMachineFonts"),
        USEPLACEDGLYPHS("UsePlacedGlyphs");

        private String value;

        private TextOutputModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TextOutputModeEnum fromValue(String text) {
            for (TextOutputModeEnum b : TextOutputModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TextOutputModeEnum> {
            public void write(JsonWriter jsonWriter, TextOutputModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TextOutputModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TextOutputModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

