/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.LinkElement;
import com.aspose.words.cloud.model.PreferredWidth;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with all formatting for a table row.")
public class TableCellFormat
extends LinkElement {
    @SerializedName(value="BottomPadding")
    protected Double bottomPadding = null;
    @SerializedName(value="FitText")
    protected Boolean fitText = null;
    @SerializedName(value="HorizontalMerge")
    protected HorizontalMergeEnum horizontalMerge = null;
    @SerializedName(value="LeftPadding")
    protected Double leftPadding = null;
    @SerializedName(value="Orientation")
    protected OrientationEnum orientation = null;
    @SerializedName(value="PreferredWidth")
    protected PreferredWidth preferredWidth = null;
    @SerializedName(value="RightPadding")
    protected Double rightPadding = null;
    @SerializedName(value="TopPadding")
    protected Double topPadding = null;
    @SerializedName(value="VerticalAlignment")
    protected VerticalAlignmentEnum verticalAlignment = null;
    @SerializedName(value="VerticalMerge")
    protected VerticalMergeEnum verticalMerge = null;
    @SerializedName(value="Width")
    protected Double width = null;
    @SerializedName(value="WrapText")
    protected Boolean wrapText = null;

    @ApiModelProperty(value="Gets or sets the amount of space (in points) to add below the contents of the cell.")
    public Double getBottomPadding() {
        return this.bottomPadding;
    }

    public TableCellFormat bottomPadding(Double bottomPadding) {
        this.bottomPadding = bottomPadding;
        return this;
    }

    public void setBottomPadding(Double bottomPadding) {
        this.bottomPadding = bottomPadding;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to fit text in the cell, compress each paragraph to the width of the cell.")
    public Boolean getFitText() {
        return this.fitText;
    }

    public TableCellFormat fitText(Boolean fitText) {
        this.fitText = fitText;
        return this;
    }

    public void setFitText(Boolean fitText) {
        this.fitText = fitText;
    }

    @ApiModelProperty(value="Gets or sets the option that controls how the cell is merged horizontally with other cells in the row.")
    public HorizontalMergeEnum getHorizontalMerge() {
        return this.horizontalMerge;
    }

    public TableCellFormat horizontalMerge(HorizontalMergeEnum horizontalMerge) {
        this.horizontalMerge = horizontalMerge;
        return this;
    }

    public void setHorizontalMerge(HorizontalMergeEnum horizontalMerge) {
        this.horizontalMerge = horizontalMerge;
    }

    @ApiModelProperty(value="Gets or sets the amount of space (in points) to add to the left of the contents of the cell.")
    public Double getLeftPadding() {
        return this.leftPadding;
    }

    public TableCellFormat leftPadding(Double leftPadding) {
        this.leftPadding = leftPadding;
        return this;
    }

    public void setLeftPadding(Double leftPadding) {
        this.leftPadding = leftPadding;
    }

    @ApiModelProperty(value="Gets or sets the orientation of text in a table cell.")
    public OrientationEnum getOrientation() {
        return this.orientation;
    }

    public TableCellFormat orientation(OrientationEnum orientation) {
        this.orientation = orientation;
        return this;
    }

    public void setOrientation(OrientationEnum orientation) {
        this.orientation = orientation;
    }

    @ApiModelProperty(value="Gets or sets the preferred width of the cell. The preferred width (along with the table's Auto Fit option) determines how the actual width of the cell is calculated by the table layout algorithm. Table layout can be performed by Aspose.Words when it saves the document or by Microsoft Word when it displays the document.The preferred width can be specified in points or in percent. The preferred width can also be specified as \"auto\", which means no preferred width is specified.The default value is Auto.")
    public PreferredWidth getPreferredWidth() {
        return this.preferredWidth;
    }

    public TableCellFormat preferredWidth(PreferredWidth preferredWidth) {
        this.preferredWidth = preferredWidth;
        return this;
    }

    public void setPreferredWidth(PreferredWidth preferredWidth) {
        this.preferredWidth = preferredWidth;
    }

    @ApiModelProperty(value="Gets or sets the amount of space (in points) to add to the right of the contents of the cell.")
    public Double getRightPadding() {
        return this.rightPadding;
    }

    public TableCellFormat rightPadding(Double rightPadding) {
        this.rightPadding = rightPadding;
        return this;
    }

    public void setRightPadding(Double rightPadding) {
        this.rightPadding = rightPadding;
    }

    @ApiModelProperty(value="Gets or sets the amount of space (in points) to add above the contents of the cell.")
    public Double getTopPadding() {
        return this.topPadding;
    }

    public TableCellFormat topPadding(Double topPadding) {
        this.topPadding = topPadding;
        return this;
    }

    public void setTopPadding(Double topPadding) {
        this.topPadding = topPadding;
    }

    @ApiModelProperty(value="Gets or sets the vertical alignment of text in the cell.")
    public VerticalAlignmentEnum getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public TableCellFormat verticalAlignment(VerticalAlignmentEnum verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    public void setVerticalAlignment(VerticalAlignmentEnum verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    @ApiModelProperty(value="Gets or sets the option that controls how the cell is merged with other cells vertically. Cells can only be merged vertically if their left and right boundaries are identical.When cells are vertically merged, the display areas of the merged cells are consolidated. The consolidated area is used to display the contents of the first vertically merged cell and all other vertically merged cells must be empty.")
    public VerticalMergeEnum getVerticalMerge() {
        return this.verticalMerge;
    }

    public TableCellFormat verticalMerge(VerticalMergeEnum verticalMerge) {
        this.verticalMerge = verticalMerge;
        return this;
    }

    public void setVerticalMerge(VerticalMergeEnum verticalMerge) {
        this.verticalMerge = verticalMerge;
    }

    @ApiModelProperty(value="Gets or sets the width of the cell in points. The width is calculated by Aspose.Words on document loading and saving. Currently, not every combination of table, cell and document properties is supported. The returned value may not be accurate for some documents. It may not exactly match the cell width as calculated by MS Word when the document is opened in MS Word.Setting this property is not recommended. There is no guarantee that the cell will actually have the set width. The width may be adjusted to accommodate cell contents in an auto-fit table layout. Cells in other rows may have conflicting width settings. The table may be resized to fit into the container or to meet table width settings. Consider using PreferredWidth for setting the cell width. Setting this property sets PreferredWidth implicitly since version 15.8.")
    public Double getWidth() {
        return this.width;
    }

    public TableCellFormat width(Double width) {
        this.width = width;
        return this;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to wrap text in the cell.")
    public Boolean getWrapText() {
        return this.wrapText;
    }

    public TableCellFormat wrapText(Boolean wrapText) {
        this.wrapText = wrapText;
        return this;
    }

    public void setWrapText(Boolean wrapText) {
        this.wrapText = wrapText;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.preferredWidth != null) {
            this.preferredWidth.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableCellFormat tableCellFormat = (TableCellFormat)o;
        return Objects.equals(this.bottomPadding, tableCellFormat.bottomPadding) && Objects.equals(this.fitText, tableCellFormat.fitText) && Objects.equals((Object)this.horizontalMerge, (Object)tableCellFormat.horizontalMerge) && Objects.equals(this.leftPadding, tableCellFormat.leftPadding) && Objects.equals((Object)this.orientation, (Object)tableCellFormat.orientation) && Objects.equals(this.preferredWidth, tableCellFormat.preferredWidth) && Objects.equals(this.rightPadding, tableCellFormat.rightPadding) && Objects.equals(this.topPadding, tableCellFormat.topPadding) && Objects.equals((Object)this.verticalAlignment, (Object)tableCellFormat.verticalAlignment) && Objects.equals((Object)this.verticalMerge, (Object)tableCellFormat.verticalMerge) && Objects.equals(this.width, tableCellFormat.width) && Objects.equals(this.wrapText, tableCellFormat.wrapText) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.bottomPadding, this.fitText, this.horizontalMerge, this.leftPadding, this.orientation, this.preferredWidth, this.rightPadding, this.topPadding, this.verticalAlignment, this.verticalMerge, this.width, this.wrapText, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableCellFormat {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    bottomPadding: ").append(this.toIndentedString(this.getBottomPadding())).append("\n");
        sb.append("    fitText: ").append(this.toIndentedString(this.getFitText())).append("\n");
        sb.append("    horizontalMerge: ").append(this.toIndentedString((Object)this.getHorizontalMerge())).append("\n");
        sb.append("    leftPadding: ").append(this.toIndentedString(this.getLeftPadding())).append("\n");
        sb.append("    orientation: ").append(this.toIndentedString((Object)this.getOrientation())).append("\n");
        sb.append("    preferredWidth: ").append(this.toIndentedString(this.getPreferredWidth())).append("\n");
        sb.append("    rightPadding: ").append(this.toIndentedString(this.getRightPadding())).append("\n");
        sb.append("    topPadding: ").append(this.toIndentedString(this.getTopPadding())).append("\n");
        sb.append("    verticalAlignment: ").append(this.toIndentedString((Object)this.getVerticalAlignment())).append("\n");
        sb.append("    verticalMerge: ").append(this.toIndentedString((Object)this.getVerticalMerge())).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.getWidth())).append("\n");
        sb.append("    wrapText: ").append(this.toIndentedString(this.getWrapText())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum HorizontalMergeEnum {
        NONE("None"),
        FIRST("First"),
        PREVIOUS("Previous");

        private String value;

        private HorizontalMergeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static HorizontalMergeEnum fromValue(String text) {
            for (HorizontalMergeEnum b : HorizontalMergeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<HorizontalMergeEnum> {
            public void write(JsonWriter jsonWriter, HorizontalMergeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public HorizontalMergeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return HorizontalMergeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OrientationEnum {
        HORIZONTAL("Horizontal"),
        DOWNWARD("Downward"),
        UPWARD("Upward"),
        HORIZONTALROTATEDFAREAST("HorizontalRotatedFarEast"),
        VERTICALFAREAST("VerticalFarEast"),
        VERTICALROTATEDFAREAST("VerticalRotatedFarEast");

        private String value;

        private OrientationEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OrientationEnum fromValue(String text) {
            for (OrientationEnum b : OrientationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OrientationEnum> {
            public void write(JsonWriter jsonWriter, OrientationEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OrientationEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OrientationEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerticalAlignmentEnum {
        TOP("Top"),
        CENTER("Center"),
        BOTTOM("Bottom");

        private String value;

        private VerticalAlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerticalAlignmentEnum fromValue(String text) {
            for (VerticalAlignmentEnum b : VerticalAlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<VerticalAlignmentEnum> {
            public void write(JsonWriter jsonWriter, VerticalAlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VerticalAlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerticalAlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerticalMergeEnum {
        NONE("None"),
        FIRST("First"),
        PREVIOUS("Previous");

        private String value;

        private VerticalMergeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerticalMergeEnum fromValue(String text) {
            for (VerticalMergeEnum b : VerticalMergeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<VerticalMergeEnum> {
            public void write(JsonWriter jsonWriter, VerticalMergeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VerticalMergeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerticalMergeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

