/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.NodeLink;
import com.aspose.words.cloud.model.TableCell;
import com.aspose.words.cloud.model.TableRowFormat;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with a table row element.")
public class TableRow
extends NodeLink {
    @SerializedName(value="TableCellList")
    protected List<TableCell> tableCellList = null;
    @SerializedName(value="RowFormat")
    protected TableRowFormat rowFormat = null;

    @ApiModelProperty(value="Gets or sets the collection of rows.")
    public List<TableCell> getTableCellList() {
        return this.tableCellList;
    }

    public TableRow tableCellList(List<TableCell> tableCellList) {
        this.tableCellList = tableCellList;
        return this;
    }

    public TableRow addTableCellListItem(TableCell tableCellListItem) {
        if (this.tableCellList == null) {
            this.tableCellList = new ArrayList<TableCell>();
        }
        this.tableCellList.add(tableCellListItem);
        return this;
    }

    public void setTableCellList(List<TableCell> tableCellList) {
        this.tableCellList = tableCellList;
    }

    @ApiModelProperty(value="Gets or sets the formatting properties of a row.")
    public TableRowFormat getRowFormat() {
        return this.rowFormat;
    }

    public TableRow rowFormat(TableRowFormat rowFormat) {
        this.rowFormat = rowFormat;
        return this;
    }

    public void setRowFormat(TableRowFormat rowFormat) {
        this.rowFormat = rowFormat;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.tableCellList != null) {
            for (ModelIfc modelIfc : this.tableCellList) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
        if (this.rowFormat != null) {
            this.rowFormat.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableRow tableRow = (TableRow)o;
        return Objects.equals(this.tableCellList, tableRow.tableCellList) && Objects.equals(this.rowFormat, tableRow.rowFormat) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableCellList, this.rowFormat, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableRow {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.getNodeId())).append("\n");
        sb.append("    tableCellList: ").append(this.toIndentedString(this.getTableCellList())).append("\n");
        sb.append("    rowFormat: ").append(this.toIndentedString(this.getRowFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

