/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.LinkElement;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with formatting for a table row.")
public class TableRowFormat
extends LinkElement {
    @SerializedName(value="Height")
    protected Double height = null;
    @SerializedName(value="HeightRule")
    protected HeightRuleEnum heightRule = null;
    @SerializedName(value="AllowBreakAcrossPages")
    protected Boolean allowBreakAcrossPages = null;
    @SerializedName(value="HeadingFormat")
    protected Boolean headingFormat = null;

    @ApiModelProperty(value="Gets or sets the height of the table row in points.")
    public Double getHeight() {
        return this.height;
    }

    public TableRowFormat height(Double height) {
        this.height = height;
        return this;
    }

    public void setHeight(Double height) {
        this.height = height;
    }

    @ApiModelProperty(value="Gets or sets the rule for determining the height of the table row.")
    public HeightRuleEnum getHeightRule() {
        return this.heightRule;
    }

    public TableRowFormat heightRule(HeightRuleEnum heightRule) {
        this.heightRule = heightRule;
        return this;
    }

    public void setHeightRule(HeightRuleEnum heightRule) {
        this.heightRule = heightRule;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the text in a table row is allowed to split across a page break.")
    public Boolean getAllowBreakAcrossPages() {
        return this.allowBreakAcrossPages;
    }

    public TableRowFormat allowBreakAcrossPages(Boolean allowBreakAcrossPages) {
        this.allowBreakAcrossPages = allowBreakAcrossPages;
        return this;
    }

    public void setAllowBreakAcrossPages(Boolean allowBreakAcrossPages) {
        this.allowBreakAcrossPages = allowBreakAcrossPages;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the row is repeated as a table heading on every page when the table spans more than one page.")
    public Boolean getHeadingFormat() {
        return this.headingFormat;
    }

    public TableRowFormat headingFormat(Boolean headingFormat) {
        this.headingFormat = headingFormat;
        return this;
    }

    public void setHeadingFormat(Boolean headingFormat) {
        this.headingFormat = headingFormat;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableRowFormat tableRowFormat = (TableRowFormat)o;
        return Objects.equals(this.height, tableRowFormat.height) && Objects.equals((Object)this.heightRule, (Object)tableRowFormat.heightRule) && Objects.equals(this.allowBreakAcrossPages, tableRowFormat.allowBreakAcrossPages) && Objects.equals(this.headingFormat, tableRowFormat.headingFormat) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.height, this.heightRule, this.allowBreakAcrossPages, this.headingFormat, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TableRowFormat {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.getHeight())).append("\n");
        sb.append("    heightRule: ").append(this.toIndentedString((Object)this.getHeightRule())).append("\n");
        sb.append("    allowBreakAcrossPages: ").append(this.toIndentedString(this.getAllowBreakAcrossPages())).append("\n");
        sb.append("    headingFormat: ").append(this.toIndentedString(this.getHeadingFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum HeightRuleEnum {
        ATLEAST("AtLeast"),
        EXACTLY("Exactly"),
        AUTO("Auto");

        private String value;

        private HeightRuleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static HeightRuleEnum fromValue(String text) {
            for (HeightRuleEnum b : HeightRuleEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<HeightRuleEnum> {
            public void write(JsonWriter jsonWriter, HeightRuleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public HeightRuleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return HeightRuleEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

