/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.TxtSaveOptionsBaseData;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for text save options.")
public class TextSaveOptionsData
extends TxtSaveOptionsBaseData {
    @SerializedName(value="AddBidiMarks")
    protected Boolean addBidiMarks = null;
    @SerializedName(value="MaxCharactersPerLine")
    protected Integer maxCharactersPerLine = null;
    @SerializedName(value="OfficeMathExportMode")
    protected OfficeMathExportModeEnum officeMathExportMode = null;
    @SerializedName(value="PreserveTableLayout")
    protected Boolean preserveTableLayout = null;
    @SerializedName(value="SimplifyListLabels")
    protected Boolean simplifyListLabels = null;

    @ApiModelProperty(value="Gets or sets a value indicating whether to add bi-directional marks before each BiDi run when exporting in plain text format. The default value is true.")
    public Boolean getAddBidiMarks() {
        return this.addBidiMarks;
    }

    public TextSaveOptionsData addBidiMarks(Boolean addBidiMarks) {
        this.addBidiMarks = addBidiMarks;
        return this;
    }

    public void setAddBidiMarks(Boolean addBidiMarks) {
        this.addBidiMarks = addBidiMarks;
    }

    @ApiModelProperty(value="Gets or sets an integer value that specifies the maximum number of characters per one line. The default value is 0, that means no limit.")
    public Integer getMaxCharactersPerLine() {
        return this.maxCharactersPerLine;
    }

    public TextSaveOptionsData maxCharactersPerLine(Integer maxCharactersPerLine) {
        this.maxCharactersPerLine = maxCharactersPerLine;
        return this;
    }

    public void setMaxCharactersPerLine(Integer maxCharactersPerLine) {
        this.maxCharactersPerLine = maxCharactersPerLine;
    }

    @ApiModelProperty(value="Gets or sets a value that specifies how OfficeMath will be written to the output file. The default value is Text.")
    public OfficeMathExportModeEnum getOfficeMathExportMode() {
        return this.officeMathExportMode;
    }

    public TextSaveOptionsData officeMathExportMode(OfficeMathExportModeEnum officeMathExportMode) {
        this.officeMathExportMode = officeMathExportMode;
        return this;
    }

    public void setOfficeMathExportMode(OfficeMathExportModeEnum officeMathExportMode) {
        this.officeMathExportMode = officeMathExportMode;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the program should attempt to preserve layout of tables when saving in the plain text format.")
    public Boolean getPreserveTableLayout() {
        return this.preserveTableLayout;
    }

    public TextSaveOptionsData preserveTableLayout(Boolean preserveTableLayout) {
        this.preserveTableLayout = preserveTableLayout;
        return this;
    }

    public void setPreserveTableLayout(Boolean preserveTableLayout) {
        this.preserveTableLayout = preserveTableLayout;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the program should simplify list labels in case of complex label formatting not being adequately represented by plain text.")
    public Boolean getSimplifyListLabels() {
        return this.simplifyListLabels;
    }

    public TextSaveOptionsData simplifyListLabels(Boolean simplifyListLabels) {
        this.simplifyListLabels = simplifyListLabels;
        return this;
    }

    public void setSimplifyListLabels(Boolean simplifyListLabels) {
        this.simplifyListLabels = simplifyListLabels;
    }

    public TextSaveOptionsData() {
        this.saveFormat = "txt";
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.maxCharactersPerLine == null) {
            throw new ApiException(400, "Property MaxCharactersPerLine in TextSaveOptionsData is required.");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextSaveOptionsData textSaveOptionsData = (TextSaveOptionsData)o;
        return Objects.equals(this.addBidiMarks, textSaveOptionsData.addBidiMarks) && Objects.equals(this.maxCharactersPerLine, textSaveOptionsData.maxCharactersPerLine) && Objects.equals((Object)this.officeMathExportMode, (Object)textSaveOptionsData.officeMathExportMode) && Objects.equals(this.preserveTableLayout, textSaveOptionsData.preserveTableLayout) && Objects.equals(this.simplifyListLabels, textSaveOptionsData.simplifyListLabels) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.addBidiMarks, this.maxCharactersPerLine, this.officeMathExportMode, this.preserveTableLayout, this.simplifyListLabels, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextSaveOptionsData {\n");
        sb.append("    allowEmbeddingPostScriptFonts: ").append(this.toIndentedString(this.getAllowEmbeddingPostScriptFonts())).append("\n");
        sb.append("    customTimeZoneInfoData: ").append(this.toIndentedString(this.getCustomTimeZoneInfoData())).append("\n");
        sb.append("    dml3DEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDml3DEffectsRenderingMode())).append("\n");
        sb.append("    dmlEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDmlEffectsRenderingMode())).append("\n");
        sb.append("    dmlRenderingMode: ").append(this.toIndentedString((Object)this.getDmlRenderingMode())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    imlRenderingMode: ").append(this.toIndentedString((Object)this.getImlRenderingMode())).append("\n");
        sb.append("    updateAmbiguousTextFont: ").append(this.toIndentedString(this.getUpdateAmbiguousTextFont())).append("\n");
        sb.append("    updateCreatedTimeProperty: ").append(this.toIndentedString(this.getUpdateCreatedTimeProperty())).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.getUpdateFields())).append("\n");
        sb.append("    updateLastPrintedProperty: ").append(this.toIndentedString(this.getUpdateLastPrintedProperty())).append("\n");
        sb.append("    updateLastSavedTimeProperty: ").append(this.toIndentedString(this.getUpdateLastSavedTimeProperty())).append("\n");
        sb.append("    zipOutput: ").append(this.toIndentedString(this.getZipOutput())).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString(this.getEncoding())).append("\n");
        sb.append("    exportHeadersFootersMode: ").append(this.toIndentedString((Object)this.getExportHeadersFootersMode())).append("\n");
        sb.append("    forcePageBreaks: ").append(this.toIndentedString(this.getForcePageBreaks())).append("\n");
        sb.append("    paragraphBreak: ").append(this.toIndentedString(this.getParagraphBreak())).append("\n");
        sb.append("    addBidiMarks: ").append(this.toIndentedString(this.getAddBidiMarks())).append("\n");
        sb.append("    maxCharactersPerLine: ").append(this.toIndentedString(this.getMaxCharactersPerLine())).append("\n");
        sb.append("    officeMathExportMode: ").append(this.toIndentedString((Object)this.getOfficeMathExportMode())).append("\n");
        sb.append("    preserveTableLayout: ").append(this.toIndentedString(this.getPreserveTableLayout())).append("\n");
        sb.append("    simplifyListLabels: ").append(this.toIndentedString(this.getSimplifyListLabels())).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.getSaveFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OfficeMathExportModeEnum {
        TEXT("Text"),
        LATEX("Latex");

        private String value;

        private OfficeMathExportModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OfficeMathExportModeEnum fromValue(String text) {
            for (OfficeMathExportModeEnum b : OfficeMathExportModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OfficeMathExportModeEnum> {
            public void write(JsonWriter jsonWriter, OfficeMathExportModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OfficeMathExportModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OfficeMathExportModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

