/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.SaveOptionsData;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Base class for save options of text formats.")
public abstract class TxtSaveOptionsBaseData
extends SaveOptionsData {
    @SerializedName(value="Encoding")
    protected String encoding = null;
    @SerializedName(value="ExportHeadersFootersMode")
    protected ExportHeadersFootersModeEnum exportHeadersFootersMode = null;
    @SerializedName(value="ForcePageBreaks")
    protected Boolean forcePageBreaks = null;
    @SerializedName(value="ParagraphBreak")
    protected String paragraphBreak = null;

    @ApiModelProperty(value="Gets or sets the character encoding to use when exporting in plain text format.")
    public String getEncoding() {
        return this.encoding;
    }

    public TxtSaveOptionsBaseData encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @ApiModelProperty(value="Gets or sets the option that controls whether to output headers and footers when exporting in plain text format. The default value is TxtExportHeadersFootersMode.PrimaryOnly.")
    public ExportHeadersFootersModeEnum getExportHeadersFootersMode() {
        return this.exportHeadersFootersMode;
    }

    public TxtSaveOptionsBaseData exportHeadersFootersMode(ExportHeadersFootersModeEnum exportHeadersFootersMode) {
        this.exportHeadersFootersMode = exportHeadersFootersMode;
        return this;
    }

    public void setExportHeadersFootersMode(ExportHeadersFootersModeEnum exportHeadersFootersMode) {
        this.exportHeadersFootersMode = exportHeadersFootersMode;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the page breaks should be preserved during export. The default value is false.")
    public Boolean getForcePageBreaks() {
        return this.forcePageBreaks;
    }

    public TxtSaveOptionsBaseData forcePageBreaks(Boolean forcePageBreaks) {
        this.forcePageBreaks = forcePageBreaks;
        return this;
    }

    public void setForcePageBreaks(Boolean forcePageBreaks) {
        this.forcePageBreaks = forcePageBreaks;
    }

    @ApiModelProperty(value="Gets or sets the string to use as a paragraph break when exporting in plain text format.")
    public String getParagraphBreak() {
        return this.paragraphBreak;
    }

    public TxtSaveOptionsBaseData paragraphBreak(String paragraphBreak) {
        this.paragraphBreak = paragraphBreak;
        return this;
    }

    public void setParagraphBreak(String paragraphBreak) {
        this.paragraphBreak = paragraphBreak;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TxtSaveOptionsBaseData txtSaveOptionsBaseData = (TxtSaveOptionsBaseData)o;
        return Objects.equals(this.encoding, txtSaveOptionsBaseData.encoding) && Objects.equals((Object)this.exportHeadersFootersMode, (Object)txtSaveOptionsBaseData.exportHeadersFootersMode) && Objects.equals(this.forcePageBreaks, txtSaveOptionsBaseData.forcePageBreaks) && Objects.equals(this.paragraphBreak, txtSaveOptionsBaseData.paragraphBreak) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.encoding, this.exportHeadersFootersMode, this.forcePageBreaks, this.paragraphBreak, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TxtSaveOptionsBaseData {\n");
        sb.append("    allowEmbeddingPostScriptFonts: ").append(this.toIndentedString(this.getAllowEmbeddingPostScriptFonts())).append("\n");
        sb.append("    customTimeZoneInfoData: ").append(this.toIndentedString(this.getCustomTimeZoneInfoData())).append("\n");
        sb.append("    dml3DEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDml3DEffectsRenderingMode())).append("\n");
        sb.append("    dmlEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDmlEffectsRenderingMode())).append("\n");
        sb.append("    dmlRenderingMode: ").append(this.toIndentedString((Object)this.getDmlRenderingMode())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    imlRenderingMode: ").append(this.toIndentedString((Object)this.getImlRenderingMode())).append("\n");
        sb.append("    updateAmbiguousTextFont: ").append(this.toIndentedString(this.getUpdateAmbiguousTextFont())).append("\n");
        sb.append("    updateCreatedTimeProperty: ").append(this.toIndentedString(this.getUpdateCreatedTimeProperty())).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.getUpdateFields())).append("\n");
        sb.append("    updateLastPrintedProperty: ").append(this.toIndentedString(this.getUpdateLastPrintedProperty())).append("\n");
        sb.append("    updateLastSavedTimeProperty: ").append(this.toIndentedString(this.getUpdateLastSavedTimeProperty())).append("\n");
        sb.append("    zipOutput: ").append(this.toIndentedString(this.getZipOutput())).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.getSaveFormat())).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString(this.getEncoding())).append("\n");
        sb.append("    exportHeadersFootersMode: ").append(this.toIndentedString((Object)this.getExportHeadersFootersMode())).append("\n");
        sb.append("    forcePageBreaks: ").append(this.toIndentedString(this.getForcePageBreaks())).append("\n");
        sb.append("    paragraphBreak: ").append(this.toIndentedString(this.getParagraphBreak())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ExportHeadersFootersModeEnum {
        NONE("None"),
        PRIMARYONLY("PrimaryOnly"),
        ALLATEND("AllAtEnd");

        private String value;

        private ExportHeadersFootersModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ExportHeadersFootersModeEnum fromValue(String text) {
            for (ExportHeadersFootersModeEnum b : ExportHeadersFootersModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ExportHeadersFootersModeEnum> {
            public void write(JsonWriter jsonWriter, ExportHeadersFootersModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ExportHeadersFootersModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ExportHeadersFootersModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

