/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.WatermarkDataBase;
import com.aspose.words.cloud.model.XmlColor;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Class for insert watermark text request building.")
public class WatermarkDataText
extends WatermarkDataBase {
    @SerializedName(value="Color")
    protected XmlColor color = null;
    @SerializedName(value="FontFamily")
    protected String fontFamily = null;
    @SerializedName(value="FontSize")
    protected Double fontSize = null;
    @SerializedName(value="IsSemitrasparent")
    protected Boolean isSemitrasparent = null;
    @SerializedName(value="Layout")
    protected LayoutEnum layout = null;
    @SerializedName(value="Text")
    protected String text = null;

    @ApiModelProperty(value="Gets or sets font color. The default value is System.Drawing.Color.Silver.")
    public XmlColor getColor() {
        return this.color;
    }

    public WatermarkDataText color(XmlColor color) {
        this.color = color;
        return this;
    }

    public void setColor(XmlColor color) {
        this.color = color;
    }

    @ApiModelProperty(value="Gets or sets font family name. The default value is \"Calibri\".")
    public String getFontFamily() {
        return this.fontFamily;
    }

    public WatermarkDataText fontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
        return this;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    @ApiModelProperty(value="Gets or sets a font size. The default value is 0 - auto. Valid values range from 0 to 65.5 inclusive. Auto font size means that the watermark will be scaled to its max width and max height relative to the page margins.")
    public Double getFontSize() {
        return this.fontSize;
    }

    public WatermarkDataText fontSize(Double fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public void setFontSize(Double fontSize) {
        this.fontSize = fontSize;
    }

    @ApiModelProperty(value="Gets or sets a boolean value which is responsible for opacity of the watermark. The default value is true.")
    public Boolean getIsSemitrasparent() {
        return this.isSemitrasparent;
    }

    public WatermarkDataText isSemitrasparent(Boolean isSemitrasparent) {
        this.isSemitrasparent = isSemitrasparent;
        return this;
    }

    public void setIsSemitrasparent(Boolean isSemitrasparent) {
        this.isSemitrasparent = isSemitrasparent;
    }

    @ApiModelProperty(value="Gets or sets layout of the watermark. The default value is Aspose.Words.WatermarkLayout.Diagonal.")
    public LayoutEnum getLayout() {
        return this.layout;
    }

    public WatermarkDataText layout(LayoutEnum layout) {
        this.layout = layout;
        return this;
    }

    public void setLayout(LayoutEnum layout) {
        this.layout = layout;
    }

    @ApiModelProperty(value="Gets or sets the watermark text.")
    public String getText() {
        return this.text;
    }

    public WatermarkDataText text(String text) {
        this.text = text;
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.text == null) {
            throw new ApiException(400, "Property Text in WatermarkDataText is required.");
        }
        if (this.color != null) {
            this.color.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatermarkDataText watermarkDataText = (WatermarkDataText)o;
        return Objects.equals(this.color, watermarkDataText.color) && Objects.equals(this.fontFamily, watermarkDataText.fontFamily) && Objects.equals(this.fontSize, watermarkDataText.fontSize) && Objects.equals(this.isSemitrasparent, watermarkDataText.isSemitrasparent) && Objects.equals((Object)this.layout, (Object)watermarkDataText.layout) && Objects.equals(this.text, watermarkDataText.text) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.color, this.fontFamily, this.fontSize, this.isSemitrasparent, this.layout, this.text, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WatermarkDataText {\n");
        sb.append("    color: ").append(this.toIndentedString(this.getColor())).append("\n");
        sb.append("    fontFamily: ").append(this.toIndentedString(this.getFontFamily())).append("\n");
        sb.append("    fontSize: ").append(this.toIndentedString(this.getFontSize())).append("\n");
        sb.append("    isSemitrasparent: ").append(this.toIndentedString(this.getIsSemitrasparent())).append("\n");
        sb.append("    layout: ").append(this.toIndentedString((Object)this.getLayout())).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.getText())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LayoutEnum {
        HORIZONTAL("Horizontal"),
        DIAGONAL("Diagonal");

        private String value;

        private LayoutEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LayoutEnum fromValue(String text) {
            for (LayoutEnum b : LayoutEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<LayoutEnum> {
            public void write(JsonWriter jsonWriter, LayoutEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LayoutEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LayoutEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

