/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model.requests;

import com.aspose.words.cloud.ApiClient;
import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.Pair;
import com.aspose.words.cloud.ProgressRequestBody;
import com.aspose.words.cloud.ProgressResponseBody;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.SaveOptionsData;
import com.aspose.words.cloud.model.SaveResponse;
import com.aspose.words.cloud.model.requests.RequestIfc;
import com.aspose.words.cloud.model.responses.SaveAsOnlineResponse;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMultipart;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class SaveAsOnlineRequest
implements RequestIfc {
    private byte[] document;
    private SaveOptionsData saveOptionsData;
    private String loadEncoding;
    private String password;
    private String encryptedPassword;
    private Boolean openTypeSupport;
    private String fontsLocation;

    public SaveAsOnlineRequest(byte[] document, SaveOptionsData saveOptionsData, String loadEncoding, String password, String encryptedPassword, Boolean openTypeSupport, String fontsLocation) {
        this.document = document;
        this.saveOptionsData = saveOptionsData;
        this.loadEncoding = loadEncoding;
        this.password = password;
        this.encryptedPassword = encryptedPassword;
        this.openTypeSupport = openTypeSupport;
        this.fontsLocation = fontsLocation;
    }

    public byte[] getDocument() {
        return this.document;
    }

    public void setDocument(byte[] value) {
        this.document = value;
    }

    public SaveOptionsData getSaveOptionsData() {
        return this.saveOptionsData;
    }

    public void setSaveOptionsData(SaveOptionsData value) {
        this.saveOptionsData = value;
    }

    public String getLoadEncoding() {
        return this.loadEncoding;
    }

    public void setLoadEncoding(String value) {
        this.loadEncoding = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String value) {
        this.encryptedPassword = value;
    }

    public Boolean getOpenTypeSupport() {
        return this.openTypeSupport;
    }

    public void setOpenTypeSupport(Boolean value) {
        this.openTypeSupport = value;
    }

    public String getFontsLocation() {
        return this.fontsLocation;
    }

    public void setFontsLocation(String value) {
        this.fontsLocation = value;
    }

    @Override
    public Request buildHttpRequest(ApiClient apiClient, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener, Boolean addAuthHeaders) throws ApiException, IOException {
        if (this.getDocument() == null) {
            throw new ApiException(apiClient.getBadRequestCode(), "Missing the required parameter 'Document' when calling saveAsOnline");
        }
        if (this.getSaveOptionsData() == null) {
            throw new ApiException(apiClient.getBadRequestCode(), "Missing the required parameter 'SaveOptionsData' when calling saveAsOnline");
        }
        if (this.getSaveOptionsData() != null) {
            this.getSaveOptionsData().validate();
        }
        String localVarPath = "/words/online/put/saveAs";
        localVarPath = localVarPath.replaceAll("//", "/");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        apiClient.addParameterToQuery(localVarQueryParams, "loadEncoding", this.getLoadEncoding());
        apiClient.addParameterToQuery(localVarQueryParams, "password", this.getPassword());
        apiClient.addParameterToQuery(localVarQueryParams, "encryptedPassword", this.getEncryptedPassword());
        apiClient.addParameterToQuery(localVarQueryParams, "openTypeSupport", this.getOpenTypeSupport());
        apiClient.addParameterToQuery(localVarQueryParams, "fontsLocation", this.getFontsLocation());
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        ArrayList<FileReference> localFilesContentParams = new ArrayList<FileReference>();
        LinkedHashMap<String, Object> localVarFormParams = new LinkedHashMap<String, Object>();
        if (this.getDocument() != null) {
            localVarFormParams.put("Document", this.getDocument());
        }
        if (this.getSaveOptionsData() != null) {
            localVarFormParams.put("SaveOptionsData", this.getSaveOptionsData());
        }
        if (progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){
                final /* synthetic */ SaveAsOnlineRequest this$0;
                {
                    this.this$0 = this$0;
                }

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        return apiClient.buildRequest(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarHeaderParams, localVarFormParams, localFilesContentParams, addAuthHeaders, progressRequestListener);
    }

    @Override
    public SaveAsOnlineResponse deserializeResponse(ApiClient apiClient, Response response) throws ApiException, MessagingException, IOException {
        MimeMultipart multipart = apiClient.getMultipartFromResponse(response);
        return new SaveAsOnlineResponse((SaveResponse)apiClient.parseModel(apiClient.findBodyPartInMultipart("Model", multipart), (Type)((Object)SaveResponse.class)), apiClient.parseFilesCollection(apiClient.findBodyPartInMultipart("Document", multipart)));
    }
}

