/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.bookmark;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.BookmarkData;
import com.aspose.words.cloud.model.BookmarkInsert;
import com.aspose.words.cloud.model.BookmarkResponse;
import com.aspose.words.cloud.model.BookmarksResponse;
import com.aspose.words.cloud.model.Position;
import com.aspose.words.cloud.model.PositionInsideNode;
import com.aspose.words.cloud.model.requests.DeleteBookmarkOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteBookmarkRequest;
import com.aspose.words.cloud.model.requests.DeleteBookmarksOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteBookmarksRequest;
import com.aspose.words.cloud.model.requests.GetBookmarkByNameOnlineRequest;
import com.aspose.words.cloud.model.requests.GetBookmarkByNameRequest;
import com.aspose.words.cloud.model.requests.GetBookmarksOnlineRequest;
import com.aspose.words.cloud.model.requests.GetBookmarksRequest;
import com.aspose.words.cloud.model.requests.InsertBookmarkOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertBookmarkRequest;
import com.aspose.words.cloud.model.requests.UpdateBookmarkOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateBookmarkRequest;
import com.aspose.words.cloud.model.responses.InsertBookmarkOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateBookmarkOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestBookmark
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/Bookmarks";
    private String localFile = "Common/test_multi_pages.docx";
    private String bookmarkName = "aspose";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetBookmarks() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentBookmarks.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetBookmarksRequest request = new GetBookmarksRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null);
        BookmarksResponse result = TestInitializer.wordsApi.getBookmarks(request);
        TestBookmark.assertNotNull((Object)result);
    }

    @Test
    public void testGetBookmarksOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetBookmarksOnlineRequest request = new GetBookmarksOnlineRequest(requestDocument, null, null, null, null);
        BookmarksResponse result = TestInitializer.wordsApi.getBookmarksOnline(request);
        TestBookmark.assertNotNull((Object)result);
    }

    @Test
    public void testGetBookmarkByName() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentBookmarkByName.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetBookmarkByNameRequest request = new GetBookmarkByNameRequest(remoteFileName, this.bookmarkName, this.remoteDataFolder, null, null, null, null, null);
        BookmarkResponse result = TestInitializer.wordsApi.getBookmarkByName(request);
        TestBookmark.assertNotNull((Object)result);
    }

    @Test
    public void testGetBookmarkByNameOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetBookmarkByNameOnlineRequest request = new GetBookmarkByNameOnlineRequest(requestDocument, this.bookmarkName, null, null, null, null);
        BookmarkResponse result = TestInitializer.wordsApi.getBookmarkByNameOnline(request);
        TestBookmark.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateBookmark() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateDocumentBookmark.docx";
        String bookmarkText = "This will be the text for Aspose";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        BookmarkData requestBookmarkData = new BookmarkData();
        requestBookmarkData.setName(this.bookmarkName);
        requestBookmarkData.setText(bookmarkText);
        UpdateBookmarkRequest request = new UpdateBookmarkRequest(remoteFileName, this.bookmarkName, requestBookmarkData, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        BookmarkResponse result = TestInitializer.wordsApi.updateBookmark(request);
        TestBookmark.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateBookmarkOnline() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateDocumentBookmark.docx";
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        BookmarkData requestBookmarkData = new BookmarkData();
        requestBookmarkData.setName(this.bookmarkName);
        requestBookmarkData.setText("This will be the text for Aspose");
        UpdateBookmarkOnlineRequest request = new UpdateBookmarkOnlineRequest(requestDocument, this.bookmarkName, requestBookmarkData, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName, null, null);
        UpdateBookmarkOnlineResponse result = TestInitializer.wordsApi.updateBookmarkOnline(request);
        TestBookmark.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteBookmark() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteBookmark.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteBookmarkRequest request = new DeleteBookmarkRequest(remoteFileName, this.bookmarkName, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteBookmark(request);
    }

    @Test
    public void testDeleteBookmarkOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteBookmarkOnlineRequest request = new DeleteBookmarkOnlineRequest(requestDocument, this.bookmarkName, null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteBookmarkOnline(request);
        TestBookmark.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteBookmarks() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteBookmarks.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteBookmarksRequest request = new DeleteBookmarksRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteBookmarks(request);
    }

    @Test
    public void testDeleteBookmarksOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteBookmarksOnlineRequest request = new DeleteBookmarksOnlineRequest(requestDocument, null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteBookmarksOnline(request);
        TestBookmark.assertNotNull((Object)result);
    }

    @Test
    public void testInsertBookmark() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertBookmark.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        PositionInsideNode requestBookmarkStartRange = new PositionInsideNode();
        requestBookmarkStartRange.setNodeId("0.0.0.0");
        requestBookmarkStartRange.setOffset(Integer.valueOf(0));
        PositionInsideNode requestBookmarkEndRange = new PositionInsideNode();
        requestBookmarkEndRange.setNodeId("0.0.0.0");
        requestBookmarkEndRange.setOffset(Integer.valueOf(0));
        BookmarkInsert requestBookmark = new BookmarkInsert();
        requestBookmark.setStartRange((Position)requestBookmarkStartRange);
        requestBookmark.setEndRange((Position)requestBookmarkEndRange);
        requestBookmark.setName("new_bookmark");
        requestBookmark.setText("Some text");
        InsertBookmarkRequest request = new InsertBookmarkRequest(remoteFileName, requestBookmark, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        BookmarkResponse result = TestInitializer.wordsApi.insertBookmark(request);
        TestBookmark.assertNotNull((Object)result);
    }

    @Test
    public void testInsertBookmarkOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        PositionInsideNode requestBookmarkStartRange = new PositionInsideNode();
        requestBookmarkStartRange.setNodeId("0.0.0.0");
        requestBookmarkStartRange.setOffset(Integer.valueOf(0));
        PositionInsideNode requestBookmarkEndRange = new PositionInsideNode();
        requestBookmarkEndRange.setNodeId("0.0.0.0");
        requestBookmarkEndRange.setOffset(Integer.valueOf(0));
        BookmarkInsert requestBookmark = new BookmarkInsert();
        requestBookmark.setStartRange((Position)requestBookmarkStartRange);
        requestBookmark.setEndRange((Position)requestBookmarkEndRange);
        requestBookmark.setName("new_bookmark");
        requestBookmark.setText("Some text");
        InsertBookmarkOnlineRequest request = new InsertBookmarkOnlineRequest(requestDocument, requestBookmark, null, null, null, null, null, null, null);
        InsertBookmarkOnlineResponse result = TestInitializer.wordsApi.insertBookmarkOnline(request);
        TestBookmark.assertNotNull((Object)result);
    }
}

