/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.document;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.CompressOptions;
import com.aspose.words.cloud.model.CompressResponse;
import com.aspose.words.cloud.model.requests.CompressDocumentOnlineRequest;
import com.aspose.words.cloud.model.requests.CompressDocumentRequest;
import com.aspose.words.cloud.model.responses.CompressDocumentOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestCompressDocument
extends TestCase {
    private String remoteFolder = TestInitializer.RemoteTestFolder + "/DocumentActions/CompressDocument";
    private String localFolder = "DocumentActions/CompressDocument";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testCompressDocument() throws ApiException, MessagingException, IOException {
        String localName = "TestCompress.docx";
        String remoteName = "TestCompress.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + localName), this.remoteFolder + "/" + remoteName);
        CompressOptions requestCompressOptions = new CompressOptions();
        CompressDocumentRequest request = new CompressDocumentRequest(remoteName, requestCompressOptions, this.remoteFolder, null, null, null, null, null, null);
        CompressResponse result = TestInitializer.wordsApi.compressDocument(request);
        TestCompressDocument.assertNotNull((Object)result);
        TestCompressDocument.assertNotNull((Object)result.getDocument());
    }

    @Test
    public void testCompressDocumentOnline() throws ApiException, MessagingException, IOException {
        String localName = "TestCompress.docx";
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFolder + "/" + localName).toAbsolutePath());
        CompressOptions requestCompressOptions = new CompressOptions();
        CompressDocumentOnlineRequest request = new CompressDocumentOnlineRequest(requestDocument, requestCompressOptions, null, null, null, null, null);
        CompressDocumentOnlineResponse result = TestInitializer.wordsApi.compressDocumentOnline(request);
        TestCompressDocument.assertNotNull((Object)result);
    }
}

