/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.document;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.DocumentResponse;
import com.aspose.words.cloud.model.requests.CreateDocumentRequest;
import com.aspose.words.cloud.model.requests.GetDocumentRequest;
import jakarta.mail.MessagingException;
import java.io.IOException;
import junit.framework.TestCase;
import org.junit.Test;

public class TestDocument
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentActions/Document";
    private String localFile = "Common/test_multi_pages.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetDocument() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocument.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetDocumentRequest request = new GetDocumentRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null);
        DocumentResponse result = TestInitializer.wordsApi.getDocument(request);
        TestDocument.assertNotNull((Object)result);
        TestDocument.assertNotNull((Object)result.getDocument());
        TestDocument.assertEquals((String)"TestGetDocument.docx", (String)result.getDocument().getFileName());
    }

    @Test
    public void testCreateDocument() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestCreateDocument.doc";
        CreateDocumentRequest request = new CreateDocumentRequest(remoteFileName, this.remoteDataFolder, null);
        DocumentResponse result = TestInitializer.wordsApi.createDocument(request);
        TestDocument.assertNotNull((Object)result);
        TestDocument.assertNotNull((Object)result.getDocument());
        TestDocument.assertEquals((String)"TestCreateDocument.doc", (String)result.getDocument().getFileName());
    }
}

