/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.document;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.RevisionsModificationResponse;
import com.aspose.words.cloud.model.RevisionsResponse;
import com.aspose.words.cloud.model.requests.AcceptAllRevisionsOnlineRequest;
import com.aspose.words.cloud.model.requests.AcceptAllRevisionsRequest;
import com.aspose.words.cloud.model.requests.GetAllRevisionsOnlineRequest;
import com.aspose.words.cloud.model.requests.GetAllRevisionsRequest;
import com.aspose.words.cloud.model.requests.RejectAllRevisionsOnlineRequest;
import com.aspose.words.cloud.model.requests.RejectAllRevisionsRequest;
import com.aspose.words.cloud.model.responses.AcceptAllRevisionsOnlineResponse;
import com.aspose.words.cloud.model.responses.RejectAllRevisionsOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestRevisions
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentActions/Revisions";
    private String localFile = "DocumentElements/Revisions/TestRevisions.doc";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testAcceptAllRevisions() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestAcceptAllRevisions.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        AcceptAllRevisionsRequest request = new AcceptAllRevisionsRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName);
        RevisionsModificationResponse result = TestInitializer.wordsApi.acceptAllRevisions(request);
        TestRevisions.assertNotNull((Object)result);
        TestRevisions.assertNotNull((Object)result.getResult());
        TestRevisions.assertNotNull((Object)result.getResult().getDest());
    }

    @Test
    public void testAcceptAllRevisionsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        AcceptAllRevisionsOnlineRequest request = new AcceptAllRevisionsOnlineRequest(requestDocument, null, null, null, null, null);
        AcceptAllRevisionsOnlineResponse result = TestInitializer.wordsApi.acceptAllRevisionsOnline(request);
        TestRevisions.assertNotNull((Object)result);
        TestRevisions.assertNotNull((Object)result.getDocument());
        TestRevisions.assertNotNull((Object)result.getModel());
        TestRevisions.assertNotNull((Object)result.getModel().getResult());
        TestRevisions.assertNotNull((Object)result.getModel().getResult().getDest());
    }

    @Test
    public void testRejectAllRevisions() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestRejectAllRevisions.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        RejectAllRevisionsRequest request = new RejectAllRevisionsRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName);
        RevisionsModificationResponse result = TestInitializer.wordsApi.rejectAllRevisions(request);
        TestRevisions.assertNotNull((Object)result);
        TestRevisions.assertNotNull((Object)result.getResult());
        TestRevisions.assertNotNull((Object)result.getResult().getDest());
    }

    @Test
    public void testRejectAllRevisionsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        RejectAllRevisionsOnlineRequest request = new RejectAllRevisionsOnlineRequest(requestDocument, null, null, null, null, null);
        RejectAllRevisionsOnlineResponse result = TestInitializer.wordsApi.rejectAllRevisionsOnline(request);
        TestRevisions.assertNotNull((Object)result);
        TestRevisions.assertNotNull((Object)result.getDocument());
        TestRevisions.assertNotNull((Object)result.getModel());
        TestRevisions.assertNotNull((Object)result.getModel().getResult());
        TestRevisions.assertNotNull((Object)result.getModel().getResult().getDest());
    }

    @Test
    public void testGetAllRevisions() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestAcceptAllRevisions.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetAllRevisionsRequest request = new GetAllRevisionsRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null);
        RevisionsResponse result = TestInitializer.wordsApi.getAllRevisions(request);
        TestRevisions.assertNotNull((Object)result);
        TestRevisions.assertNotNull((Object)result.getRevisions());
        TestRevisions.assertEquals((int)6, (int)result.getRevisions().getRevisions().size());
    }

    @Test
    public void testGetAllRevisionsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetAllRevisionsOnlineRequest request = new GetAllRevisionsOnlineRequest(requestDocument, null, null, null, null);
        RevisionsResponse result = TestInitializer.wordsApi.getAllRevisionsOnline(request);
        TestRevisions.assertNotNull((Object)result);
        TestRevisions.assertNotNull((Object)result.getRevisions());
        TestRevisions.assertEquals((int)6, (int)result.getRevisions().getRevisions().size());
    }
}

