/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.document;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.SplitDocumentResponse;
import com.aspose.words.cloud.model.requests.SplitDocumentOnlineRequest;
import com.aspose.words.cloud.model.requests.SplitDocumentRequest;
import com.aspose.words.cloud.model.responses.SplitDocumentOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestSplitDocumentToFormat
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentActions/SplitDocument";
    private String localFile = "Common/test_multi_pages.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testSplitDocument() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestSplitDocument.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        SplitDocumentRequest request = new SplitDocumentRequest(remoteFileName, "text", this.remoteDataFolder, null, null, null, null, null, TestInitializer.RemoteTestOut + "/TestSplitDocument.text", Integer.valueOf(1), Integer.valueOf(2), null, null);
        SplitDocumentResponse result = TestInitializer.wordsApi.splitDocument(request);
        TestSplitDocumentToFormat.assertNotNull((Object)result);
        TestSplitDocumentToFormat.assertNotNull((Object)result.getSplitResult());
        TestSplitDocumentToFormat.assertNotNull((Object)result.getSplitResult().getPages());
        TestSplitDocumentToFormat.assertEquals((int)2, (int)result.getSplitResult().getPages().size());
    }

    @Test
    public void testSplitDocumentOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        SplitDocumentOnlineRequest request = new SplitDocumentOnlineRequest(requestDocument, "text", null, null, null, null, TestInitializer.RemoteTestOut + "/TestSplitDocument.text", Integer.valueOf(1), Integer.valueOf(2), null, null);
        SplitDocumentOnlineResponse result = TestInitializer.wordsApi.splitDocumentOnline(request);
        TestSplitDocumentToFormat.assertNotNull((Object)result);
    }
}

