/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.headerFooter;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.HeaderFooterResponse;
import com.aspose.words.cloud.model.HeaderFootersResponse;
import com.aspose.words.cloud.model.NodeLink;
import com.aspose.words.cloud.model.requests.DeleteHeaderFooterOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteHeaderFooterRequest;
import com.aspose.words.cloud.model.requests.DeleteHeadersFootersOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteHeadersFootersRequest;
import com.aspose.words.cloud.model.requests.GetHeaderFooterOfSectionOnlineRequest;
import com.aspose.words.cloud.model.requests.GetHeaderFooterOfSectionRequest;
import com.aspose.words.cloud.model.requests.GetHeaderFooterOnlineRequest;
import com.aspose.words.cloud.model.requests.GetHeaderFooterRequest;
import com.aspose.words.cloud.model.requests.GetHeaderFootersOnlineRequest;
import com.aspose.words.cloud.model.requests.GetHeaderFootersRequest;
import com.aspose.words.cloud.model.requests.InsertHeaderFooterOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertHeaderFooterRequest;
import com.aspose.words.cloud.model.responses.InsertHeaderFooterOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestHeaderFooter
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/HeaderFooters";
    private String localFile = "DocumentElements/HeaderFooters/HeadersFooters.doc";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetHeaderFooters() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetHeadersFooters.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetHeaderFootersRequest request = new GetHeaderFootersRequest(remoteFileName, "", this.remoteDataFolder, null, null, null, null, null, null);
        HeaderFootersResponse result = TestInitializer.wordsApi.getHeaderFooters(request);
        TestHeaderFooter.assertNotNull((Object)result);
        TestHeaderFooter.assertNotNull((Object)result.getHeaderFooters());
        TestHeaderFooter.assertNotNull((Object)result.getHeaderFooters().getList());
        TestHeaderFooter.assertEquals((int)6, (int)result.getHeaderFooters().getList().size());
    }

    @Test
    public void testGetHeaderFootersOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetHeaderFootersOnlineRequest request = new GetHeaderFootersOnlineRequest(requestDocument, "", null, null, null, null, null);
        HeaderFootersResponse result = TestInitializer.wordsApi.getHeaderFootersOnline(request);
        TestHeaderFooter.assertNotNull((Object)result);
    }

    @Test
    public void testGetHeaderFooter() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetHeaderFooter.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetHeaderFooterRequest request = new GetHeaderFooterRequest(remoteFileName, Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null, null);
        HeaderFooterResponse result = TestInitializer.wordsApi.getHeaderFooter(request);
        TestHeaderFooter.assertNotNull((Object)result);
        TestHeaderFooter.assertNotNull((Object)result.getHeaderFooter());
        TestHeaderFooter.assertNotNull((Object)result.getHeaderFooter().getChildNodes());
        TestHeaderFooter.assertEquals((int)1, (int)result.getHeaderFooter().getChildNodes().size());
        TestHeaderFooter.assertEquals((String)"0.0.0", (String)((NodeLink)result.getHeaderFooter().getChildNodes().get(0)).getNodeId());
    }

    @Test
    public void testGetHeaderFooterOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetHeaderFooterOnlineRequest request = new GetHeaderFooterOnlineRequest(requestDocument, Integer.valueOf(0), null, null, null, null, null);
        HeaderFooterResponse result = TestInitializer.wordsApi.getHeaderFooterOnline(request);
        TestHeaderFooter.assertNotNull((Object)result);
    }

    @Test
    public void testGetHeaderFooterOfSection() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetHeaderFooterOfSection.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetHeaderFooterOfSectionRequest request = new GetHeaderFooterOfSectionRequest(remoteFileName, Integer.valueOf(0), Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null, null);
        HeaderFooterResponse result = TestInitializer.wordsApi.getHeaderFooterOfSection(request);
        TestHeaderFooter.assertNotNull((Object)result);
        TestHeaderFooter.assertNotNull((Object)result.getHeaderFooter());
        TestHeaderFooter.assertNotNull((Object)result.getHeaderFooter().getChildNodes());
        TestHeaderFooter.assertEquals((int)1, (int)result.getHeaderFooter().getChildNodes().size());
        TestHeaderFooter.assertEquals((String)"0.0.0", (String)((NodeLink)result.getHeaderFooter().getChildNodes().get(0)).getNodeId());
    }

    @Test
    public void testGetHeaderFooterOfSectionOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetHeaderFooterOfSectionOnlineRequest request = new GetHeaderFooterOfSectionOnlineRequest(requestDocument, Integer.valueOf(0), Integer.valueOf(0), null, null, null, null, null);
        HeaderFooterResponse result = TestInitializer.wordsApi.getHeaderFooterOfSectionOnline(request);
        TestHeaderFooter.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteHeaderFooter() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteHeaderFooter.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteHeaderFooterRequest request = new DeleteHeaderFooterRequest(remoteFileName, "", Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteHeaderFooter(request);
    }

    @Test
    public void testDeleteHeaderFooterOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteHeaderFooterOnlineRequest request = new DeleteHeaderFooterOnlineRequest(requestDocument, "", Integer.valueOf(0), null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteHeaderFooterOnline(request);
        TestHeaderFooter.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteHeadersFooters() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteHeadersFooters.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteHeadersFootersRequest request = new DeleteHeadersFootersRequest(remoteFileName, "", this.remoteDataFolder, null, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteHeadersFooters(request);
    }

    @Test
    public void testDeleteHeadersFootersOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteHeadersFootersOnlineRequest request = new DeleteHeadersFootersOnlineRequest(requestDocument, "", null, null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteHeadersFootersOnline(request);
        TestHeaderFooter.assertNotNull((Object)result);
    }

    @Test
    public void testInsertHeaderFooter() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertHeaderFooter.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        InsertHeaderFooterRequest request = new InsertHeaderFooterRequest(remoteFileName, "", "FooterEven", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        HeaderFooterResponse result = TestInitializer.wordsApi.insertHeaderFooter(request);
        TestHeaderFooter.assertNotNull((Object)result);
    }

    @Test
    public void testInsertHeaderFooterOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        InsertHeaderFooterOnlineRequest request = new InsertHeaderFooterOnlineRequest(requestDocument, "", "FooterEven", null, null, null, null, null, null, null);
        InsertHeaderFooterOnlineResponse result = TestInitializer.wordsApi.insertHeaderFooterOnline(request);
        TestHeaderFooter.assertNotNull((Object)result);
        TestHeaderFooter.assertNotNull((Object)result.getModel().getHeaderFooter());
        TestHeaderFooter.assertNotNull((Object)result.getModel().getHeaderFooter().getChildNodes());
        TestHeaderFooter.assertEquals((int)1, (int)result.getModel().getHeaderFooter().getChildNodes().size());
        TestHeaderFooter.assertEquals((String)"0.2.0", (String)((NodeLink)result.getModel().getHeaderFooter().getChildNodes().get(0)).getNodeId());
    }
}

