/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.hyperlink;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.Hyperlink;
import com.aspose.words.cloud.model.HyperlinkResponse;
import com.aspose.words.cloud.model.HyperlinksResponse;
import com.aspose.words.cloud.model.requests.GetDocumentHyperlinkByIndexOnlineRequest;
import com.aspose.words.cloud.model.requests.GetDocumentHyperlinkByIndexRequest;
import com.aspose.words.cloud.model.requests.GetDocumentHyperlinksOnlineRequest;
import com.aspose.words.cloud.model.requests.GetDocumentHyperlinksRequest;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestHyperlink
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/Hyperlink";
    private String localFile = "Common/test_doc.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetDocumentHyperlinkByIndex() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentHyperlinkByIndex.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetDocumentHyperlinkByIndexRequest request = new GetDocumentHyperlinkByIndexRequest(remoteFileName, Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null);
        HyperlinkResponse result = TestInitializer.wordsApi.getDocumentHyperlinkByIndex(request);
        TestHyperlink.assertNotNull((Object)result);
        TestHyperlink.assertNotNull((Object)result.getHyperlink());
        TestHyperlink.assertEquals((String)"Aspose", (String)result.getHyperlink().getDisplayText());
    }

    @Test
    public void testGetDocumentHyperlinkByIndexOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetDocumentHyperlinkByIndexOnlineRequest request = new GetDocumentHyperlinkByIndexOnlineRequest(requestDocument, Integer.valueOf(0), null, null, null, null);
        HyperlinkResponse result = TestInitializer.wordsApi.getDocumentHyperlinkByIndexOnline(request);
        TestHyperlink.assertNotNull((Object)result);
    }

    @Test
    public void testGetDocumentHyperlinks() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetDocumentHyperlinks.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetDocumentHyperlinksRequest request = new GetDocumentHyperlinksRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null);
        HyperlinksResponse result = TestInitializer.wordsApi.getDocumentHyperlinks(request);
        TestHyperlink.assertNotNull((Object)result);
        TestHyperlink.assertNotNull((Object)result.getHyperlinks());
        TestHyperlink.assertNotNull((Object)result.getHyperlinks().getHyperlinkList());
        TestHyperlink.assertEquals((int)2, (int)result.getHyperlinks().getHyperlinkList().size());
        TestHyperlink.assertEquals((String)"Aspose", (String)((Hyperlink)result.getHyperlinks().getHyperlinkList().get(0)).getDisplayText());
    }

    @Test
    public void testGetDocumentHyperlinksOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetDocumentHyperlinksOnlineRequest request = new GetDocumentHyperlinksOnlineRequest(requestDocument, null, null, null, null);
        HyperlinksResponse result = TestInitializer.wordsApi.getDocumentHyperlinksOnline(request);
        TestHyperlink.assertNotNull((Object)result);
    }
}

