/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.lists;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.ListInfo;
import com.aspose.words.cloud.model.ListInsert;
import com.aspose.words.cloud.model.ListLevelUpdate;
import com.aspose.words.cloud.model.ListResponse;
import com.aspose.words.cloud.model.ListUpdate;
import com.aspose.words.cloud.model.ListsResponse;
import com.aspose.words.cloud.model.requests.GetListOnlineRequest;
import com.aspose.words.cloud.model.requests.GetListRequest;
import com.aspose.words.cloud.model.requests.GetListsOnlineRequest;
import com.aspose.words.cloud.model.requests.GetListsRequest;
import com.aspose.words.cloud.model.requests.InsertListOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertListRequest;
import com.aspose.words.cloud.model.requests.UpdateListLevelOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateListLevelRequest;
import com.aspose.words.cloud.model.requests.UpdateListOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateListRequest;
import com.aspose.words.cloud.model.responses.InsertListOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateListLevelOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateListOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestLists
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/Lists";
    private String localFile = "DocumentElements/Lists/ListsGet.doc";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetLists() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetLists.doc";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetListsRequest request = new GetListsRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null);
        ListsResponse result = TestInitializer.wordsApi.getLists(request);
        TestLists.assertNotNull((Object)result);
        TestLists.assertNotNull((Object)result.getLists());
        TestLists.assertNotNull((Object)result.getLists().getListInfo());
        TestLists.assertEquals((int)2, (int)result.getLists().getListInfo().size());
        TestLists.assertEquals((Object)1, (Object)((ListInfo)result.getLists().getListInfo().get(0)).getListId());
    }

    @Test
    public void testGetListsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetListsOnlineRequest request = new GetListsOnlineRequest(requestDocument, null, null, null, null);
        ListsResponse result = TestInitializer.wordsApi.getListsOnline(request);
        TestLists.assertNotNull((Object)result);
    }

    @Test
    public void testGetList() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetList.doc";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetListRequest request = new GetListRequest(remoteFileName, Integer.valueOf(1), this.remoteDataFolder, null, null, null, null, null);
        ListResponse result = TestInitializer.wordsApi.getList(request);
        TestLists.assertNotNull((Object)result);
        TestLists.assertNotNull((Object)result.getList());
        TestLists.assertEquals((Object)1, (Object)result.getList().getListId());
    }

    @Test
    public void testGetListOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetListOnlineRequest request = new GetListOnlineRequest(requestDocument, Integer.valueOf(1), null, null, null, null);
        ListResponse result = TestInitializer.wordsApi.getListOnline(request);
        TestLists.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateList() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateList.doc";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        ListUpdate requestListUpdate = new ListUpdate();
        requestListUpdate.setIsRestartAtEachSection(Boolean.valueOf(true));
        UpdateListRequest request = new UpdateListRequest(remoteFileName, Integer.valueOf(1), requestListUpdate, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        ListResponse result = TestInitializer.wordsApi.updateList(request);
        TestLists.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateListOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        ListUpdate requestListUpdate = new ListUpdate();
        requestListUpdate.setIsRestartAtEachSection(Boolean.valueOf(true));
        UpdateListOnlineRequest request = new UpdateListOnlineRequest(requestDocument, Integer.valueOf(1), requestListUpdate, null, null, null, null, null, null, null);
        UpdateListOnlineResponse result = TestInitializer.wordsApi.updateListOnline(request);
        TestLists.assertNotNull((Object)result);
        TestLists.assertNotNull((Object)result.getModel().getList());
        TestLists.assertEquals((Object)1, (Object)result.getModel().getList().getListId());
        TestLists.assertEquals((Object)true, (Object)result.getModel().getList().getIsRestartAtEachSection());
    }

    @Test
    public void testUpdateListLevel() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateListLevel.doc";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        ListLevelUpdate requestListUpdate = new ListLevelUpdate();
        requestListUpdate.setAlignment(ListLevelUpdate.AlignmentEnum.RIGHT);
        UpdateListLevelRequest request = new UpdateListLevelRequest(remoteFileName, Integer.valueOf(1), Integer.valueOf(1), requestListUpdate, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        ListResponse result = TestInitializer.wordsApi.updateListLevel(request);
        TestLists.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateListLevelOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        ListLevelUpdate requestListUpdate = new ListLevelUpdate();
        requestListUpdate.setAlignment(ListLevelUpdate.AlignmentEnum.RIGHT);
        UpdateListLevelOnlineRequest request = new UpdateListLevelOnlineRequest(requestDocument, Integer.valueOf(1), requestListUpdate, Integer.valueOf(1), null, null, null, null, null, null, null);
        UpdateListLevelOnlineResponse result = TestInitializer.wordsApi.updateListLevelOnline(request);
        TestLists.assertNotNull((Object)result);
        TestLists.assertNotNull((Object)result.getModel().getList());
        TestLists.assertNotNull((Object)result.getModel().getList().getListLevels());
        TestLists.assertNotNull((Object)result.getModel().getList().getListLevels().getListLevel());
        TestLists.assertEquals((int)9, (int)result.getModel().getList().getListLevels().getListLevel().size());
    }

    @Test
    public void testInsertList() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertList.doc";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        ListInsert requestListInsert = new ListInsert();
        requestListInsert.setTemplate(ListInsert.TemplateEnum.OUTLINELEGAL);
        InsertListRequest request = new InsertListRequest(remoteFileName, requestListInsert, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        ListResponse result = TestInitializer.wordsApi.insertList(request);
        TestLists.assertNotNull((Object)result);
        TestLists.assertNotNull((Object)result.getList());
        TestLists.assertEquals((Object)3, (Object)result.getList().getListId());
    }

    @Test
    public void testInsertListOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        ListInsert requestListInsert = new ListInsert();
        requestListInsert.setTemplate(ListInsert.TemplateEnum.OUTLINELEGAL);
        InsertListOnlineRequest request = new InsertListOnlineRequest(requestDocument, requestListInsert, null, null, null, null, null, null, null);
        InsertListOnlineResponse result = TestInitializer.wordsApi.insertListOnline(request);
        TestLists.assertNotNull((Object)result);
    }
}

