/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.mailMerge;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.DocumentResponse;
import com.aspose.words.cloud.model.FieldOptions;
import com.aspose.words.cloud.model.UserInformation;
import com.aspose.words.cloud.model.requests.ExecuteMailMergeOnlineRequest;
import com.aspose.words.cloud.model.requests.ExecuteMailMergeRequest;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestExecuteTemplateWithFieldOptions
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentActions/MailMerge";
    private String mailMergeFolder = "DocumentActions/MailMerge";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testExecuteTemplateWithFieldOptions() throws ApiException, MessagingException, IOException {
        String localDocumentFile = "TestMailMergeWithOptions.docx";
        String remoteFileName = "TestMailMergeWithOptions.docx";
        String localDataFile = new String(Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.mailMergeFolder + "/TestMailMergeData.xml")), "utf8");
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.mailMergeFolder + "/" + localDocumentFile), this.remoteDataFolder + "/" + remoteFileName);
        UserInformation requestOptionsCurrentUser = new UserInformation();
        requestOptionsCurrentUser.setName("SdkTestUser");
        FieldOptions requestOptions = new FieldOptions();
        requestOptions.setCurrentUser(requestOptionsCurrentUser);
        ExecuteMailMergeRequest request = new ExecuteMailMergeRequest(remoteFileName, localDataFile, requestOptions, this.remoteDataFolder, null, null, null, null, null, null, null, null, null, null, TestInitializer.RemoteTestOut + "/" + remoteFileName);
        DocumentResponse result = TestInitializer.wordsApi.executeMailMerge(request);
        TestExecuteTemplateWithFieldOptions.assertNotNull((Object)result);
        TestExecuteTemplateWithFieldOptions.assertNotNull((Object)result.getDocument());
        TestExecuteTemplateWithFieldOptions.assertEquals((String)"TestMailMergeWithOptions.docx", (String)result.getDocument().getFileName());
    }

    @Test
    public void testExecuteTemplateOnlineWithFieldOptions() throws ApiException, MessagingException, IOException {
        String localDocumentFile = "TestMailMergeWithOptions.docx";
        String localDataFile = "TestMailMergeData.xml";
        byte[] requestTemplate = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.mailMergeFolder + "/" + localDocumentFile).toAbsolutePath());
        byte[] requestData = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.mailMergeFolder + "/" + localDataFile).toAbsolutePath());
        UserInformation requestOptionsCurrentUser = new UserInformation();
        requestOptionsCurrentUser.setName("SdkTestUser");
        FieldOptions requestOptions = new FieldOptions();
        requestOptions.setCurrentUser(requestOptionsCurrentUser);
        ExecuteMailMergeOnlineRequest request = new ExecuteMailMergeOnlineRequest(requestTemplate, requestData, requestOptions, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.executeMailMergeOnline(request);
        TestExecuteTemplateWithFieldOptions.assertNotNull((Object)result);
    }
}

