/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.mathObject;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.OfficeMathObject;
import com.aspose.words.cloud.model.OfficeMathObjectResponse;
import com.aspose.words.cloud.model.OfficeMathObjectsResponse;
import com.aspose.words.cloud.model.requests.DeleteOfficeMathObjectOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteOfficeMathObjectRequest;
import com.aspose.words.cloud.model.requests.DeleteOfficeMathObjectsOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteOfficeMathObjectsRequest;
import com.aspose.words.cloud.model.requests.GetOfficeMathObjectOnlineRequest;
import com.aspose.words.cloud.model.requests.GetOfficeMathObjectRequest;
import com.aspose.words.cloud.model.requests.GetOfficeMathObjectsOnlineRequest;
import com.aspose.words.cloud.model.requests.GetOfficeMathObjectsRequest;
import com.aspose.words.cloud.model.requests.RenderMathObjectOnlineRequest;
import com.aspose.words.cloud.model.requests.RenderMathObjectRequest;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestMathObject
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/MathObjects";
    private String localFile = "DocumentElements/MathObjects/MathObjects.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetOfficeMathObjects() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetOfficeMathObjects.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetOfficeMathObjectsRequest request = new GetOfficeMathObjectsRequest(remoteFileName, "", this.remoteDataFolder, null, null, null, null, null);
        OfficeMathObjectsResponse result = TestInitializer.wordsApi.getOfficeMathObjects(request);
        TestMathObject.assertNotNull((Object)result);
        TestMathObject.assertNotNull((Object)result.getOfficeMathObjects());
        TestMathObject.assertNotNull((Object)result.getOfficeMathObjects().getList());
        TestMathObject.assertEquals((int)16, (int)result.getOfficeMathObjects().getList().size());
        TestMathObject.assertEquals((String)"0.0.0.0", (String)((OfficeMathObject)result.getOfficeMathObjects().getList().get(0)).getNodeId());
    }

    @Test
    public void testGetOfficeMathObjectsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetOfficeMathObjectsOnlineRequest request = new GetOfficeMathObjectsOnlineRequest(requestDocument, "", null, null, null, null);
        OfficeMathObjectsResponse result = TestInitializer.wordsApi.getOfficeMathObjectsOnline(request);
        TestMathObject.assertNotNull((Object)result);
    }

    @Test
    public void testGetOfficeMathObjectsWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetOfficeMathObjectsWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetOfficeMathObjectsRequest request = new GetOfficeMathObjectsRequest(remoteFileName, null, this.remoteDataFolder, null, null, null, null, null);
        OfficeMathObjectsResponse result = TestInitializer.wordsApi.getOfficeMathObjects(request);
        TestMathObject.assertNotNull((Object)result);
        TestMathObject.assertNotNull((Object)result.getOfficeMathObjects());
        TestMathObject.assertNotNull((Object)result.getOfficeMathObjects().getList());
        TestMathObject.assertEquals((int)16, (int)result.getOfficeMathObjects().getList().size());
        TestMathObject.assertEquals((String)"0.0.0.0", (String)((OfficeMathObject)result.getOfficeMathObjects().getList().get(0)).getNodeId());
    }

    @Test
    public void testGetOfficeMathObject() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetOfficeMathObject.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetOfficeMathObjectRequest request = new GetOfficeMathObjectRequest(remoteFileName, Integer.valueOf(0), "", this.remoteDataFolder, null, null, null, null, null);
        OfficeMathObjectResponse result = TestInitializer.wordsApi.getOfficeMathObject(request);
        TestMathObject.assertNotNull((Object)result);
        TestMathObject.assertNotNull((Object)result.getOfficeMathObject());
        TestMathObject.assertEquals((String)"0.0.0.0", (String)result.getOfficeMathObject().getNodeId());
    }

    @Test
    public void testGetOfficeMathObjectOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetOfficeMathObjectOnlineRequest request = new GetOfficeMathObjectOnlineRequest(requestDocument, Integer.valueOf(0), "", null, null, null, null);
        OfficeMathObjectResponse result = TestInitializer.wordsApi.getOfficeMathObjectOnline(request);
        TestMathObject.assertNotNull((Object)result);
    }

    @Test
    public void testGetOfficeMathObjectWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetOfficeMathObjectWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetOfficeMathObjectRequest request = new GetOfficeMathObjectRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null);
        OfficeMathObjectResponse result = TestInitializer.wordsApi.getOfficeMathObject(request);
        TestMathObject.assertNotNull((Object)result);
        TestMathObject.assertNotNull((Object)result.getOfficeMathObject());
        TestMathObject.assertEquals((String)"0.0.0.0", (String)result.getOfficeMathObject().getNodeId());
    }

    @Test
    public void testRenderMathObject() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestRenderMathObject.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        RenderMathObjectRequest request = new RenderMathObjectRequest(remoteFileName, "png", Integer.valueOf(0), "", this.remoteDataFolder, null, null, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.renderMathObject(request);
        TestMathObject.assertNotNull((Object)result);
    }

    @Test
    public void testRenderMathObjectOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        RenderMathObjectOnlineRequest request = new RenderMathObjectOnlineRequest(requestDocument, "png", Integer.valueOf(0), "", null, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.renderMathObjectOnline(request);
        TestMathObject.assertNotNull((Object)result);
    }

    @Test
    public void testRenderMathObjectWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestRenderMathObjectWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        RenderMathObjectRequest request = new RenderMathObjectRequest(remoteFileName, "png", Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.renderMathObject(request);
        TestMathObject.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteOfficeMathObject() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteOfficeMathObject.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteOfficeMathObjectRequest request = new DeleteOfficeMathObjectRequest(remoteFileName, Integer.valueOf(0), "", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteOfficeMathObject(request);
    }

    @Test
    public void testDeleteOfficeMathObjectOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteOfficeMathObjectOnlineRequest request = new DeleteOfficeMathObjectOnlineRequest(requestDocument, Integer.valueOf(0), "", null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteOfficeMathObjectOnline(request);
        TestMathObject.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteOfficeMathObjectWithoutNodePath() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteOfficeMathObjectWithoutNodePath.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteOfficeMathObjectRequest request = new DeleteOfficeMathObjectRequest(remoteFileName, Integer.valueOf(0), null, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteOfficeMathObject(request);
    }

    @Test
    public void testDeleteOfficeMathObjects() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteOfficeMathObject.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteOfficeMathObjectsRequest request = new DeleteOfficeMathObjectsRequest(remoteFileName, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteOfficeMathObjects(request);
    }

    @Test
    public void testDeleteOfficeMathObjectsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteOfficeMathObjectsOnlineRequest request = new DeleteOfficeMathObjectsOnlineRequest(requestDocument, null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteOfficeMathObjectsOnline(request);
        TestMathObject.assertNotNull((Object)result);
    }
}

