/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.pageSetup;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.PageSetup;
import com.aspose.words.cloud.model.SectionPageSetupResponse;
import com.aspose.words.cloud.model.requests.GetSectionPageSetupOnlineRequest;
import com.aspose.words.cloud.model.requests.GetSectionPageSetupRequest;
import com.aspose.words.cloud.model.requests.RenderPageOnlineRequest;
import com.aspose.words.cloud.model.requests.RenderPageRequest;
import com.aspose.words.cloud.model.requests.UpdateSectionPageSetupOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateSectionPageSetupRequest;
import com.aspose.words.cloud.model.responses.UpdateSectionPageSetupOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import junit.framework.TestCase;
import org.junit.Test;

public class TestPageSetup
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/PageSetup";
    private String localFile = "Common/test_multi_pages.docx";
    private String localTextFile = "DocumentElements/Text/SampleWordDocument.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetSectionPageSetup() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetSectionPageSetup.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetSectionPageSetupRequest request = new GetSectionPageSetupRequest(remoteFileName, Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null);
        SectionPageSetupResponse result = TestInitializer.wordsApi.getSectionPageSetup(request);
        TestPageSetup.assertNotNull((Object)result);
        TestPageSetup.assertNotNull((Object)result.getPageSetup());
        TestPageSetup.assertEquals((Object)1, (Object)result.getPageSetup().getLineStartingNumber());
    }

    @Test
    public void testGetSectionPageSetupOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetSectionPageSetupOnlineRequest request = new GetSectionPageSetupOnlineRequest(requestDocument, Integer.valueOf(0), null, null, null, null);
        SectionPageSetupResponse result = TestInitializer.wordsApi.getSectionPageSetupOnline(request);
        TestPageSetup.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateSectionPageSetup() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateSectionPageSetup.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        PageSetup requestPageSetup = new PageSetup();
        requestPageSetup.setRtlGutter(Boolean.valueOf(true));
        requestPageSetup.setLeftMargin(Double.valueOf(10.0));
        requestPageSetup.setOrientation(PageSetup.OrientationEnum.LANDSCAPE);
        requestPageSetup.setPaperSize(PageSetup.PaperSizeEnum.A5);
        UpdateSectionPageSetupRequest request = new UpdateSectionPageSetupRequest(remoteFileName, Integer.valueOf(0), requestPageSetup, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        SectionPageSetupResponse result = TestInitializer.wordsApi.updateSectionPageSetup(request);
        TestPageSetup.assertNotNull((Object)result);
        TestPageSetup.assertNotNull((Object)result.getPageSetup());
        TestPageSetup.assertEquals((Object)true, (Object)result.getPageSetup().getRtlGutter());
    }

    @Test
    public void testUpdateSectionPageSetupOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        PageSetup requestPageSetup = new PageSetup();
        requestPageSetup.setRtlGutter(Boolean.valueOf(true));
        requestPageSetup.setLeftMargin(Double.valueOf(10.0));
        requestPageSetup.setOrientation(PageSetup.OrientationEnum.LANDSCAPE);
        requestPageSetup.setPaperSize(PageSetup.PaperSizeEnum.A5);
        UpdateSectionPageSetupOnlineRequest request = new UpdateSectionPageSetupOnlineRequest(requestDocument, Integer.valueOf(0), requestPageSetup, null, null, null, null, null, null, null);
        UpdateSectionPageSetupOnlineResponse result = TestInitializer.wordsApi.updateSectionPageSetupOnline(request);
        TestPageSetup.assertNotNull((Object)result);
    }

    @Test
    public void testGetRenderPage() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetRenderPage.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localTextFile), this.remoteDataFolder + "/" + remoteFileName);
        RenderPageRequest request = new RenderPageRequest(remoteFileName, Integer.valueOf(1), "jpg", this.remoteDataFolder, null, null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.renderPage(request);
        TestPageSetup.assertNotNull((Object)result);
    }

    @Test
    public void testGetRenderPageOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localTextFile).toAbsolutePath());
        RenderPageOnlineRequest request = new RenderPageOnlineRequest(requestDocument, Integer.valueOf(1), "jpg", null, null, null, null, null);
        byte[] result = TestInitializer.wordsApi.renderPageOnline(request);
        TestPageSetup.assertNotNull((Object)result);
    }
}

