/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.report;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.DocumentResponse;
import com.aspose.words.cloud.model.ReportBuildOptions;
import com.aspose.words.cloud.model.ReportEngineSettings;
import com.aspose.words.cloud.model.requests.BuildReportOnlineRequest;
import com.aspose.words.cloud.model.requests.BuildReportRequest;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.junit.Test;

public class TestBuildReport
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentActions/Reporting";
    private String reportingFolder = "DocumentActions/Reporting";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testBuildReportOnline() throws ApiException, MessagingException, IOException {
        String localDocumentFile = "ReportTemplate.docx";
        String localDataFile = new String(Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.reportingFolder + "/ReportData.json")), "utf8");
        byte[] requestTemplate = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.reportingFolder + "/" + localDocumentFile).toAbsolutePath());
        ReportEngineSettings requestReportEngineSettings = new ReportEngineSettings();
        requestReportEngineSettings.setDataSourceType(ReportEngineSettings.DataSourceTypeEnum.JSON);
        requestReportEngineSettings.setDataSourceName("persons");
        BuildReportOnlineRequest request = new BuildReportOnlineRequest(requestTemplate, localDataFile, requestReportEngineSettings, null);
        byte[] result = TestInitializer.wordsApi.buildReportOnline(request);
        TestBuildReport.assertNotNull((Object)result);
    }

    @Test
    public void testBuildReport() throws ApiException, MessagingException, IOException {
        String localDocumentFile = "ReportTemplate.docx";
        String remoteFileName = "TestBuildReport.docx";
        String localDataFile = new String(Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.reportingFolder + "/ReportData.json")), "utf8");
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.reportingFolder + "/" + localDocumentFile), this.remoteDataFolder + "/" + remoteFileName);
        ArrayList<ReportBuildOptions> requestReportEngineSettingsReportBuildOptions = new ArrayList<ReportBuildOptions>();
        requestReportEngineSettingsReportBuildOptions.add(ReportBuildOptions.ALLOWMISSINGMEMBERS);
        requestReportEngineSettingsReportBuildOptions.add(ReportBuildOptions.REMOVEEMPTYPARAGRAPHS);
        ReportEngineSettings requestReportEngineSettings = new ReportEngineSettings();
        requestReportEngineSettings.setDataSourceType(ReportEngineSettings.DataSourceTypeEnum.JSON);
        requestReportEngineSettings.setReportBuildOptions(requestReportEngineSettingsReportBuildOptions);
        BuildReportRequest request = new BuildReportRequest(remoteFileName, localDataFile, requestReportEngineSettings, this.remoteDataFolder, null, null, null, null, null, null);
        DocumentResponse result = TestInitializer.wordsApi.buildReport(request);
        TestBuildReport.assertNotNull((Object)result);
        TestBuildReport.assertNotNull((Object)result.getDocument());
        TestBuildReport.assertEquals((String)"TestBuildReport.docx", (String)result.getDocument().getFileName());
    }
}

