/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.run;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.RunInsert;
import com.aspose.words.cloud.model.RunResponse;
import com.aspose.words.cloud.model.RunUpdate;
import com.aspose.words.cloud.model.requests.DeleteRunOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteRunRequest;
import com.aspose.words.cloud.model.requests.InsertRunOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertRunRequest;
import com.aspose.words.cloud.model.requests.UpdateRunOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateRunRequest;
import com.aspose.words.cloud.model.responses.InsertRunOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateRunOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestRun
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/Runs";
    private String localFile = "DocumentElements/Runs/Run.doc";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testUpdateRun() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateRun.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        RunUpdate requestRun = new RunUpdate();
        requestRun.setText("run with text");
        UpdateRunRequest request = new UpdateRunRequest(remoteFileName, "paragraphs/1", Integer.valueOf(0), requestRun, this.remoteDataFolder, null, null, null, null, null, null, null, null);
        RunResponse result = TestInitializer.wordsApi.updateRun(request);
        TestRun.assertNotNull((Object)result);
        TestRun.assertNotNull((Object)result.getRun());
        TestRun.assertEquals((String)"run with text", (String)result.getRun().getText());
    }

    @Test
    public void testUpdateRunOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        RunUpdate requestRun = new RunUpdate();
        requestRun.setText("run with text");
        UpdateRunOnlineRequest request = new UpdateRunOnlineRequest(requestDocument, "paragraphs/1", requestRun, Integer.valueOf(0), null, null, null, null, null, null, null);
        UpdateRunOnlineResponse result = TestInitializer.wordsApi.updateRunOnline(request);
        TestRun.assertNotNull((Object)result);
    }

    @Test
    public void testInsertRun() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsertRun.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        RunInsert requestRun = new RunInsert();
        requestRun.setText("run with text");
        InsertRunRequest request = new InsertRunRequest(remoteFileName, requestRun, "paragraphs/1", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        RunResponse result = TestInitializer.wordsApi.insertRun(request);
        TestRun.assertNotNull((Object)result);
        TestRun.assertNotNull((Object)result.getRun());
        TestRun.assertEquals((String)"run with text", (String)result.getRun().getText());
        TestRun.assertEquals((String)"0.0.1.3", (String)result.getRun().getNodeId());
    }

    @Test
    public void testInsertRunOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        RunInsert requestRun = new RunInsert();
        requestRun.setText("run with text");
        InsertRunOnlineRequest request = new InsertRunOnlineRequest(requestDocument, requestRun, "paragraphs/1", null, null, null, null, null, null, null);
        InsertRunOnlineResponse result = TestInitializer.wordsApi.insertRunOnline(request);
        TestRun.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteRun() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteRun.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteRunRequest request = new DeleteRunRequest(remoteFileName, "paragraphs/1", Integer.valueOf(0), this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteRun(request);
    }

    @Test
    public void testDeleteRunOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteRunOnlineRequest request = new DeleteRunOnlineRequest(requestDocument, "paragraphs/1", Integer.valueOf(0), null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteRunOnline(request);
        TestRun.assertNotNull((Object)result);
    }
}

