/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.storage;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.FilesUploadResult;
import com.aspose.words.cloud.model.requests.CopyFileRequest;
import com.aspose.words.cloud.model.requests.DeleteFileRequest;
import com.aspose.words.cloud.model.requests.DownloadFileRequest;
import com.aspose.words.cloud.model.requests.MoveFileRequest;
import com.aspose.words.cloud.model.requests.UploadFileRequest;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.UUID;
import junit.framework.TestCase;
import org.junit.Test;

public class TestFile
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/Storage";
    private String localFile = "Common/test_multi_pages.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testUploadFile() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUploadFile.docx";
        byte[] requestFileContent = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        UploadFileRequest request = new UploadFileRequest(requestFileContent, this.remoteDataFolder + "/" + remoteFileName, null);
        FilesUploadResult result = TestInitializer.wordsApi.uploadFile(request);
        TestFile.assertNotNull((Object)result);
        TestFile.assertNotNull((Object)result.getUploaded());
        TestFile.assertEquals((int)1, (int)result.getUploaded().size());
        TestFile.assertEquals((String)"TestUploadFile.docx", (String)((String)result.getUploaded().get(0)));
    }

    @Test
    public void testCopyFile() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestCopyFileSrc.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        CopyFileRequest request = new CopyFileRequest(this.remoteDataFolder + "/TestCopyFileDest.docx", this.remoteDataFolder + "/" + remoteFileName, null, null, null);
        TestInitializer.wordsApi.copyFile(request);
    }

    @Test
    public void testMoveFile() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestMoveFileSrc.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        MoveFileRequest request = new MoveFileRequest(TestInitializer.RemoteTestOut + "/TestMoveFileDest_" + UUID.randomUUID().toString() + ".docx", this.remoteDataFolder + "/" + remoteFileName, null, null, null);
        TestInitializer.wordsApi.moveFile(request);
    }

    @Test
    public void testDeleteFile() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteFile.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteFileRequest request = new DeleteFileRequest(this.remoteDataFolder + "/" + remoteFileName, null, null);
        TestInitializer.wordsApi.deleteFile(request);
    }

    @Test
    public void testDownloadFile() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDownloadFile.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DownloadFileRequest request = new DownloadFileRequest(this.remoteDataFolder + "/" + remoteFileName, null, null);
        byte[] result = TestInitializer.wordsApi.downloadFile(request);
        TestFile.assertNotNull((Object)result);
    }
}

