/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.storage;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.FilesList;
import com.aspose.words.cloud.model.requests.CopyFolderRequest;
import com.aspose.words.cloud.model.requests.CreateFolderRequest;
import com.aspose.words.cloud.model.requests.DeleteFolderRequest;
import com.aspose.words.cloud.model.requests.GetFilesListRequest;
import com.aspose.words.cloud.model.requests.MoveFolderRequest;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.UUID;
import junit.framework.TestCase;
import org.junit.Test;

public class TestFolder
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/Storage";
    private String localFile = "Common/test_multi_pages.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testCreateFolder() throws ApiException, MessagingException, IOException {
        CreateFolderRequest request = new CreateFolderRequest(this.remoteDataFolder + "/TestCreateFolder", null);
        TestInitializer.wordsApi.createFolder(request);
    }

    @Test
    public void testDeleteFolder() throws ApiException, MessagingException, IOException {
        String testDeleteFolder = this.remoteDataFolder + "/TestDeleteFolder";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), testDeleteFolder + "/TestDeleteFolder.docx");
        DeleteFolderRequest request = new DeleteFolderRequest(testDeleteFolder, null, Boolean.valueOf(true));
        TestInitializer.wordsApi.deleteFolder(request);
    }

    @Test
    public void testGetFilesList() throws ApiException, MessagingException, IOException {
        GetFilesListRequest request = new GetFilesListRequest(this.remoteDataFolder, null);
        FilesList result = TestInitializer.wordsApi.getFilesList(request);
        TestFolder.assertNotNull((Object)result);
        TestFolder.assertNotNull((Object)result.getValue());
    }

    @Test
    public void testCopyFolder() throws ApiException, MessagingException, IOException {
        String folderToCopy = this.remoteDataFolder + "/TestCopyFolder";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), folderToCopy + "Src/TestCopyFolderSrc.docx");
        CopyFolderRequest request = new CopyFolderRequest(folderToCopy + "Dest", folderToCopy + "Src", null, null);
        TestInitializer.wordsApi.copyFolder(request);
    }

    @Test
    public void testMoveFolder() throws ApiException, MessagingException, IOException {
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/TestMoveFolderSrc/TestMoveFolderSrc.docx");
        MoveFolderRequest request = new MoveFolderRequest(TestInitializer.RemoteTestOut + "/TestMoveFolderDest_" + UUID.randomUUID().toString(), this.remoteDataFolder + "/TestMoveFolderSrc", null, null);
        TestInitializer.wordsApi.moveFolder(request);
    }
}

