/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.api.structuredDocumentTag;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.PathUtil;
import com.aspose.words.cloud.TestInitializer;
import com.aspose.words.cloud.model.StructuredDocumentTagInsert;
import com.aspose.words.cloud.model.StructuredDocumentTagListItem;
import com.aspose.words.cloud.model.StructuredDocumentTagResponse;
import com.aspose.words.cloud.model.StructuredDocumentTagUpdate;
import com.aspose.words.cloud.model.StructuredDocumentTagsResponse;
import com.aspose.words.cloud.model.requests.DeleteStructuredDocumentTagOnlineRequest;
import com.aspose.words.cloud.model.requests.DeleteStructuredDocumentTagRequest;
import com.aspose.words.cloud.model.requests.GetStructuredDocumentTagOnlineRequest;
import com.aspose.words.cloud.model.requests.GetStructuredDocumentTagRequest;
import com.aspose.words.cloud.model.requests.GetStructuredDocumentTagsOnlineRequest;
import com.aspose.words.cloud.model.requests.GetStructuredDocumentTagsRequest;
import com.aspose.words.cloud.model.requests.InsertStructuredDocumentTagOnlineRequest;
import com.aspose.words.cloud.model.requests.InsertStructuredDocumentTagRequest;
import com.aspose.words.cloud.model.requests.UpdateStructuredDocumentTagOnlineRequest;
import com.aspose.words.cloud.model.requests.UpdateStructuredDocumentTagRequest;
import com.aspose.words.cloud.model.responses.InsertStructuredDocumentTagOnlineResponse;
import com.aspose.words.cloud.model.responses.UpdateStructuredDocumentTagOnlineResponse;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;

public class TestStructuredDocumentTag
extends TestCase {
    private String remoteDataFolder = TestInitializer.RemoteTestFolder + "/DocumentElements/StructuredDocumentTag";
    private String localFile = "DocumentElements/StructuredDocumentTag/StructuredDocumentTag.docx";

    protected void setUp() throws Exception {
        super.setUp();
        TestInitializer.Initialize();
    }

    @Test
    public void testGetStructuredDocumentTags() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetStructuredDocumentTags.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetStructuredDocumentTagsRequest request = new GetStructuredDocumentTagsRequest(remoteFileName, "sections/0/body/paragraphs/0", this.remoteDataFolder, null, null, null, null, null);
        StructuredDocumentTagsResponse result = TestInitializer.wordsApi.getStructuredDocumentTags(request);
        TestStructuredDocumentTag.assertNotNull((Object)result);
    }

    @Test
    public void testGetStructuredDocumentTagsOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetStructuredDocumentTagsOnlineRequest request = new GetStructuredDocumentTagsOnlineRequest(requestDocument, "sections/0/body/paragraphs/0", null, null, null, null);
        StructuredDocumentTagsResponse result = TestInitializer.wordsApi.getStructuredDocumentTagsOnline(request);
        TestStructuredDocumentTag.assertNotNull((Object)result);
    }

    @Test
    public void testGetStructuredDocumentTag() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestGetStructuredDocumentTag.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        GetStructuredDocumentTagRequest request = new GetStructuredDocumentTagRequest(remoteFileName, Integer.valueOf(0), "sections/0/body/paragraphs/0", this.remoteDataFolder, null, null, null, null, null);
        StructuredDocumentTagResponse result = TestInitializer.wordsApi.getStructuredDocumentTag(request);
        TestStructuredDocumentTag.assertNotNull((Object)result);
    }

    @Test
    public void testGetStructuredDocumentTagOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        GetStructuredDocumentTagOnlineRequest request = new GetStructuredDocumentTagOnlineRequest(requestDocument, Integer.valueOf(0), "sections/0/body/paragraphs/0", null, null, null, null);
        StructuredDocumentTagResponse result = TestInitializer.wordsApi.getStructuredDocumentTagOnline(request);
        TestStructuredDocumentTag.assertNotNull((Object)result);
    }

    @Test
    public void testInsertStructuredDocumentTag() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestInsetStructuredDocumentTag.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        StructuredDocumentTagInsert requestStructuredDocumentTag = new StructuredDocumentTagInsert();
        requestStructuredDocumentTag.setSdtType(StructuredDocumentTagInsert.SdtTypeEnum.COMBOBOX);
        requestStructuredDocumentTag.setLevel(StructuredDocumentTagInsert.LevelEnum.INLINE);
        InsertStructuredDocumentTagRequest request = new InsertStructuredDocumentTagRequest(remoteFileName, requestStructuredDocumentTag, "sections/0/body/paragraphs/0", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        StructuredDocumentTagResponse result = TestInitializer.wordsApi.insertStructuredDocumentTag(request);
        TestStructuredDocumentTag.assertNotNull((Object)result);
    }

    @Test
    public void testInsertStructuredDocumentTagOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        StructuredDocumentTagInsert requestStructuredDocumentTag = new StructuredDocumentTagInsert();
        requestStructuredDocumentTag.setSdtType(StructuredDocumentTagInsert.SdtTypeEnum.COMBOBOX);
        requestStructuredDocumentTag.setLevel(StructuredDocumentTagInsert.LevelEnum.INLINE);
        InsertStructuredDocumentTagOnlineRequest request = new InsertStructuredDocumentTagOnlineRequest(requestDocument, requestStructuredDocumentTag, "sections/0/body/paragraphs/0", null, null, null, null, null, null, null);
        InsertStructuredDocumentTagOnlineResponse result = TestInitializer.wordsApi.insertStructuredDocumentTagOnline(request);
        TestStructuredDocumentTag.assertNotNull((Object)result);
    }

    @Test
    public void testDeleteStructuredDocumentTag() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestDeleteStructuredDocumentTag.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        DeleteStructuredDocumentTagRequest request = new DeleteStructuredDocumentTagRequest(remoteFileName, Integer.valueOf(0), "sections/0/body/paragraphs/0", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        TestInitializer.wordsApi.deleteStructuredDocumentTag(request);
    }

    @Test
    public void testDeleteStructuredDocumentTagOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        DeleteStructuredDocumentTagOnlineRequest request = new DeleteStructuredDocumentTagOnlineRequest(requestDocument, Integer.valueOf(0), "sections/0/body/paragraphs/0", null, null, null, null, null, null, null);
        Map result = TestInitializer.wordsApi.deleteStructuredDocumentTagOnline(request);
        TestStructuredDocumentTag.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateStructuredDocumentTag() throws ApiException, MessagingException, IOException {
        String remoteFileName = "TestUpdateStructuredDocumentTag.docx";
        TestInitializer.UploadFile(PathUtil.get(TestInitializer.LocalTestFolder, this.localFile), this.remoteDataFolder + "/" + remoteFileName);
        StructuredDocumentTagListItem requestStructuredDocumentTagListItems0 = new StructuredDocumentTagListItem();
        requestStructuredDocumentTagListItems0.setDisplayText("Aspose Words");
        requestStructuredDocumentTagListItems0.setValue("1");
        StructuredDocumentTagListItem requestStructuredDocumentTagListItems1 = new StructuredDocumentTagListItem();
        requestStructuredDocumentTagListItems1.setDisplayText("Hello world");
        requestStructuredDocumentTagListItems1.setValue("2");
        ArrayList<StructuredDocumentTagListItem> requestStructuredDocumentTagListItems = new ArrayList<StructuredDocumentTagListItem>();
        requestStructuredDocumentTagListItems.add(requestStructuredDocumentTagListItems0);
        requestStructuredDocumentTagListItems.add(requestStructuredDocumentTagListItems1);
        StructuredDocumentTagUpdate requestStructuredDocumentTag = new StructuredDocumentTagUpdate();
        requestStructuredDocumentTag.setListItems(requestStructuredDocumentTagListItems);
        UpdateStructuredDocumentTagRequest request = new UpdateStructuredDocumentTagRequest(remoteFileName, Integer.valueOf(0), requestStructuredDocumentTag, "sections/0/body/paragraphs/0", this.remoteDataFolder, null, null, null, null, null, null, null, null);
        StructuredDocumentTagResponse result = TestInitializer.wordsApi.updateStructuredDocumentTag(request);
        TestStructuredDocumentTag.assertNotNull((Object)result);
    }

    @Test
    public void testUpdateStructuredDocumentTagOnline() throws ApiException, MessagingException, IOException {
        byte[] requestDocument = Files.readAllBytes(Paths.get(TestInitializer.LocalTestFolder, this.localFile).toAbsolutePath());
        StructuredDocumentTagListItem requestStructuredDocumentTagListItems0 = new StructuredDocumentTagListItem();
        requestStructuredDocumentTagListItems0.setDisplayText("Aspose Words");
        requestStructuredDocumentTagListItems0.setValue("1");
        StructuredDocumentTagListItem requestStructuredDocumentTagListItems1 = new StructuredDocumentTagListItem();
        requestStructuredDocumentTagListItems1.setDisplayText("Hello world");
        requestStructuredDocumentTagListItems1.setValue("2");
        ArrayList<StructuredDocumentTagListItem> requestStructuredDocumentTagListItems = new ArrayList<StructuredDocumentTagListItem>();
        requestStructuredDocumentTagListItems.add(requestStructuredDocumentTagListItems0);
        requestStructuredDocumentTagListItems.add(requestStructuredDocumentTagListItems1);
        StructuredDocumentTagUpdate requestStructuredDocumentTag = new StructuredDocumentTagUpdate();
        requestStructuredDocumentTag.setListItems(requestStructuredDocumentTagListItems);
        UpdateStructuredDocumentTagOnlineRequest request = new UpdateStructuredDocumentTagOnlineRequest(requestDocument, requestStructuredDocumentTag, Integer.valueOf(0), "sections/0/body/paragraphs/0", null, null, null, null, null, null, null);
        UpdateStructuredDocumentTagOnlineResponse result = TestInitializer.wordsApi.updateStructuredDocumentTagOnline(request);
        TestStructuredDocumentTag.assertNotNull((Object)result);
    }
}

