/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud;

import com.aspose.words.cloud.JSON;
import com.aspose.words.cloud.model.ApiError;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class ApiException
extends Exception {
    private ApiError innerError = null;
    private int code = 0;
    private Map<String, List<String>> responseHeaders = null;
    private String responseBody = null;

    public ApiException() {
    }

    public ApiException(Throwable throwable) {
        super(throwable);
    }

    public ApiException(String message) {
        super(message);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        super(message, throwable);
        this.code = code;
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.setInnerError();
    }

    public ApiException(String message, int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(message, null, code, responseHeaders, responseBody);
    }

    public ApiException(String message, Throwable throwable, int code, Map<String, List<String>> responseHeaders) {
        this(message, throwable, code, responseHeaders, null);
    }

    public ApiException(int code, Map<String, List<String>> responseHeaders, String responseBody) {
        this(null, null, code, responseHeaders, responseBody);
    }

    public ApiException(int code, String message) {
        super(message);
        this.code = code;
    }

    public ApiException(int code, String message, Map<String, List<String>> responseHeaders, String responseBody) {
        this(code, message);
        this.responseHeaders = responseHeaders;
        this.responseBody = responseBody;
        this.setInnerError();
    }

    private void setInnerError() {
        if (!this.responseBody.contains("Error") || !this.responseBody.startsWith("{")) {
            return;
        }
        JsonElement elem = new JsonParser().parse(this.responseBody);
        this.innerError = (ApiError)new JSON().deserialize(elem.getAsJsonObject().get("Error").toString(), (Type)((Object)ApiError.class));
    }

    public int getCode() {
        return this.code;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public ApiError getInnerError() {
        return this.innerError;
    }
}

