/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud;

import com.aspose.words.cloud.ApiClient;
import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.requests.BatchPartRequest;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.io.IOException;
import java.net.URI;
import okio.BufferedSink;

public class ChildRequestContent
extends RequestBody {
    private static final String CRLF = "\r\n";
    private ApiClient apiClient;
    private BatchPartRequest request;
    private URI baseUri;

    public ChildRequestContent(ApiClient apiClient, BatchPartRequest request, String rootUrl) {
        this.apiClient = apiClient;
        this.request = request;
        this.baseUri = URI.create(rootUrl);
    }

    public MediaType contentType() {
        return MediaType.parse((String)"application/http; msgtype=request");
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        Request httpRequest;
        try {
            httpRequest = this.request.getRequest().buildHttpRequest(this.apiClient, null, null, false);
        }
        catch (ApiException ex) {
            throw new IOException(ex.getMessage());
        }
        bufferedSink.writeUtf8(httpRequest.method());
        bufferedSink.writeUtf8(" ");
        bufferedSink.writeUtf8(this.baseUri.relativize(httpRequest.uri()).toString());
        bufferedSink.writeUtf8(" ");
        bufferedSink.writeUtf8(CRLF);
        bufferedSink.writeUtf8("RequestId: ");
        bufferedSink.writeUtf8(this.request.getRequestId());
        bufferedSink.writeUtf8(CRLF);
        if (this.request.getParentRequestId() != null) {
            bufferedSink.writeUtf8("DependsOn: ");
            bufferedSink.writeUtf8(this.request.getParentRequestId());
            bufferedSink.writeUtf8(CRLF);
        }
        for (String key : httpRequest.headers().names()) {
            bufferedSink.writeUtf8(key);
            bufferedSink.writeUtf8(": ");
            bufferedSink.writeUtf8(httpRequest.headers().get(key));
            bufferedSink.writeUtf8(CRLF);
        }
        bufferedSink.writeUtf8(CRLF);
        if (httpRequest.body() != null) {
            httpRequest.body().writeTo(bufferedSink);
        }
    }
}

