/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.PositionInsideNode;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Comment.")
public abstract class CommentBase
implements ModelIfc {
    @SerializedName(value="RangeStart")
    protected PositionInsideNode rangeStart = null;
    @SerializedName(value="RangeEnd")
    protected PositionInsideNode rangeEnd = null;
    @SerializedName(value="Author")
    protected String author = null;
    @SerializedName(value="Initial")
    protected String initial = null;
    @SerializedName(value="DateTime")
    protected OffsetDateTime dateTime = null;
    @SerializedName(value="Text")
    protected String text = null;

    @ApiModelProperty(value="Gets or sets the link to comment range start node.")
    public PositionInsideNode getRangeStart() {
        return this.rangeStart;
    }

    public CommentBase rangeStart(PositionInsideNode rangeStart) {
        this.rangeStart = rangeStart;
        return this;
    }

    public void setRangeStart(PositionInsideNode rangeStart) {
        this.rangeStart = rangeStart;
    }

    @ApiModelProperty(value="Gets or sets the link to comment range end node.")
    public PositionInsideNode getRangeEnd() {
        return this.rangeEnd;
    }

    public CommentBase rangeEnd(PositionInsideNode rangeEnd) {
        this.rangeEnd = rangeEnd;
        return this;
    }

    public void setRangeEnd(PositionInsideNode rangeEnd) {
        this.rangeEnd = rangeEnd;
    }

    @ApiModelProperty(value="Gets or sets the author name for a comment. Cannot be null.Default is an empty string.")
    public String getAuthor() {
        return this.author;
    }

    public CommentBase author(String author) {
        this.author = author;
        return this;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @ApiModelProperty(value="Gets or sets the initials of the user associated with a specific comment. Cannot be null.Default is an empty string.")
    public String getInitial() {
        return this.initial;
    }

    public CommentBase initial(String initial) {
        this.initial = initial;
        return this;
    }

    public void setInitial(String initial) {
        this.initial = initial;
    }

    @ApiModelProperty(value="Gets or sets the date and time that the comment was made. Default is MinValue03.01.0001.")
    public OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    public CommentBase dateTime(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    public void setDateTime(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
    }

    @ApiModelProperty(value="Gets or sets text of the comment. This method allows to quickly set text of a comment from a string. The string can contain paragraph breaks, this will create paragraphs of text in the comment accordingly.")
    public String getText() {
        return this.text;
    }

    public CommentBase text(String text) {
        this.text = text;
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.rangeStart == null) {
            throw new ApiException(400, "Property RangeStart in CommentBase is required.");
        }
        if (this.rangeEnd == null) {
            throw new ApiException(400, "Property RangeEnd in CommentBase is required.");
        }
        if (this.author == null) {
            throw new ApiException(400, "Property Author in CommentBase is required.");
        }
        if (this.initial == null) {
            throw new ApiException(400, "Property Initial in CommentBase is required.");
        }
        if (this.text == null) {
            throw new ApiException(400, "Property Text in CommentBase is required.");
        }
        if (this.rangeStart != null) {
            this.rangeStart.validate();
        }
        if (this.rangeEnd != null) {
            this.rangeEnd.validate();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommentBase commentBase = (CommentBase)o;
        return Objects.equals(this.rangeStart, commentBase.rangeStart) && Objects.equals(this.rangeEnd, commentBase.rangeEnd) && Objects.equals(this.author, commentBase.author) && Objects.equals(this.initial, commentBase.initial) && Objects.equals(this.dateTime, commentBase.dateTime) && Objects.equals(this.text, commentBase.text);
    }

    public int hashCode() {
        return Objects.hash(this.rangeStart, this.rangeEnd, this.author, this.initial, this.dateTime, this.text);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CommentBase {\n");
        sb.append("    rangeStart: ").append(this.toIndentedString(this.getRangeStart())).append("\n");
        sb.append("    rangeEnd: ").append(this.toIndentedString(this.getRangeEnd())).append("\n");
        sb.append("    author: ").append(this.toIndentedString(this.getAuthor())).append("\n");
        sb.append("    initial: ").append(this.toIndentedString(this.getInitial())).append("\n");
        sb.append("    dateTime: ").append(this.toIndentedString(this.getDateTime())).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.getText())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

