/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.CompareOptions;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Container class for compare documents.")
public class CompareData
implements ModelIfc {
    @SerializedName(value="Author")
    protected String author = null;
    @SerializedName(value="CompareOptions")
    protected CompareOptions compareOptions = null;
    @SerializedName(value="ComparingWithDocument")
    protected String comparingWithDocument = null;
    @SerializedName(value="DateTime")
    protected OffsetDateTime dateTime = null;
    @SerializedName(value="FileReference")
    protected FileReference fileReference = null;
    @SerializedName(value="ResultDocumentFormat")
    protected String resultDocumentFormat = null;

    @ApiModelProperty(value="Gets or sets the initials of the author to use for revisions.")
    public String getAuthor() {
        return this.author;
    }

    public CompareData author(String author) {
        this.author = author;
        return this;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @ApiModelProperty(value="Gets or sets the compare options.")
    public CompareOptions getCompareOptions() {
        return this.compareOptions;
    }

    public CompareData compareOptions(CompareOptions compareOptions) {
        this.compareOptions = compareOptions;
        return this;
    }

    public void setCompareOptions(CompareOptions compareOptions) {
        this.compareOptions = compareOptions;
    }

    @ApiModelProperty(value="Gets or sets the path to document to compare at the server.")
    @Deprecated
    public String getComparingWithDocument() {
        return this.comparingWithDocument;
    }

    @Deprecated
    public CompareData comparingWithDocument(String comparingWithDocument) {
        this.comparingWithDocument = comparingWithDocument;
        return this;
    }

    @Deprecated
    public void setComparingWithDocument(String comparingWithDocument) {
        this.comparingWithDocument = comparingWithDocument;
    }

    @ApiModelProperty(value="Gets or sets the date and time to use for revisions.")
    public OffsetDateTime getDateTime() {
        return this.dateTime;
    }

    public CompareData dateTime(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    public void setDateTime(OffsetDateTime dateTime) {
        this.dateTime = dateTime;
    }

    @ApiModelProperty(value="Gets or sets the file reference.")
    public FileReference getFileReference() {
        return this.fileReference;
    }

    public CompareData fileReference(FileReference fileReference) {
        this.fileReference = fileReference;
        return this;
    }

    public void setFileReference(FileReference fileReference) {
        this.fileReference = fileReference;
    }

    @ApiModelProperty(value="Gets or sets the result document format.")
    public String getResultDocumentFormat() {
        return this.resultDocumentFormat;
    }

    public CompareData resultDocumentFormat(String resultDocumentFormat) {
        this.resultDocumentFormat = resultDocumentFormat;
        return this;
    }

    public void setResultDocumentFormat(String resultDocumentFormat) {
        this.resultDocumentFormat = resultDocumentFormat;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
        if (this.fileReference != null) {
            this.fileReference.getFilesContent(resultFilesContent);
        }
    }

    @Override
    public void validate() throws ApiException {
        if (this.author == null) {
            throw new ApiException(400, "Property Author in CompareData is required.");
        }
        if (this.fileReference == null) {
            throw new ApiException(400, "Property FileReference in CompareData is required.");
        }
        if (this.compareOptions != null) {
            this.compareOptions.validate();
        }
        if (this.fileReference != null) {
            this.fileReference.validate();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompareData compareData = (CompareData)o;
        return Objects.equals(this.author, compareData.author) && Objects.equals(this.compareOptions, compareData.compareOptions) && Objects.equals(this.comparingWithDocument, compareData.comparingWithDocument) && Objects.equals(this.dateTime, compareData.dateTime) && Objects.equals(this.fileReference, compareData.fileReference) && Objects.equals(this.resultDocumentFormat, compareData.resultDocumentFormat);
    }

    public int hashCode() {
        return Objects.hash(this.author, this.compareOptions, this.comparingWithDocument, this.dateTime, this.fileReference, this.resultDocumentFormat);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompareData {\n");
        sb.append("    author: ").append(this.toIndentedString(this.getAuthor())).append("\n");
        sb.append("    compareOptions: ").append(this.toIndentedString(this.getCompareOptions())).append("\n");
        sb.append("    comparingWithDocument: ").append(this.toIndentedString(this.getComparingWithDocument())).append("\n");
        sb.append("    dateTime: ").append(this.toIndentedString(this.getDateTime())).append("\n");
        sb.append("    fileReference: ").append(this.toIndentedString(this.getFileReference())).append("\n");
        sb.append("    resultDocumentFormat: ").append(this.toIndentedString(this.getResultDocumentFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

