/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Options of document compress.")
public class CompressOptions
implements ModelIfc {
    @SerializedName(value="ImagesQuality")
    protected Integer imagesQuality = null;
    @SerializedName(value="ImagesReduceSizeFactor")
    protected Integer imagesReduceSizeFactor = null;

    @ApiModelProperty(value="Gets or sets the quality level of images from 0 to 100. The default value is 75.")
    public Integer getImagesQuality() {
        return this.imagesQuality;
    }

    public CompressOptions imagesQuality(Integer imagesQuality) {
        this.imagesQuality = imagesQuality;
        return this;
    }

    public void setImagesQuality(Integer imagesQuality) {
        this.imagesQuality = imagesQuality;
    }

    @ApiModelProperty(value="Gets or sets the resize factor of images. This value determines how many times the size of the images in the document will be reduced. The parameter value must be greater than 1 for resizing. The default value is 1 and has no effect on images size.")
    public Integer getImagesReduceSizeFactor() {
        return this.imagesReduceSizeFactor;
    }

    public CompressOptions imagesReduceSizeFactor(Integer imagesReduceSizeFactor) {
        this.imagesReduceSizeFactor = imagesReduceSizeFactor;
        return this;
    }

    public void setImagesReduceSizeFactor(Integer imagesReduceSizeFactor) {
        this.imagesReduceSizeFactor = imagesReduceSizeFactor;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompressOptions compressOptions = (CompressOptions)o;
        return Objects.equals(this.imagesQuality, compressOptions.imagesQuality) && Objects.equals(this.imagesReduceSizeFactor, compressOptions.imagesReduceSizeFactor);
    }

    public int hashCode() {
        return Objects.hash(this.imagesQuality, this.imagesReduceSizeFactor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompressOptions {\n");
        sb.append("    imagesQuality: ").append(this.toIndentedString(this.getImagesQuality())).append("\n");
        sb.append("    imagesReduceSizeFactor: ").append(this.toIndentedString(this.getImagesReduceSizeFactor())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

