/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.Error;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="File upload result.")
public class FilesUploadResult
implements ModelIfc {
    @SerializedName(value="Errors")
    protected List<Error> errors = null;
    @SerializedName(value="Uploaded")
    protected List<String> uploaded = null;

    @ApiModelProperty(value="List of errors.")
    public List<Error> getErrors() {
        return this.errors;
    }

    public FilesUploadResult errors(List<Error> errors) {
        this.errors = errors;
        return this;
    }

    public FilesUploadResult addErrorsItem(Error errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<Error>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    public void setErrors(List<Error> errors) {
        this.errors = errors;
    }

    @ApiModelProperty(value="List of uploaded file names.")
    public List<String> getUploaded() {
        return this.uploaded;
    }

    public FilesUploadResult uploaded(List<String> uploaded) {
        this.uploaded = uploaded;
        return this;
    }

    public FilesUploadResult addUploadedItem(String uploadedItem) {
        if (this.uploaded == null) {
            this.uploaded = new ArrayList<String>();
        }
        this.uploaded.add(uploadedItem);
        return this;
    }

    public void setUploaded(List<String> uploaded) {
        this.uploaded = uploaded;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.errors != null) {
            for (ModelIfc modelIfc : this.errors) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilesUploadResult filesUploadResult = (FilesUploadResult)o;
        return Objects.equals(this.errors, filesUploadResult.errors) && Objects.equals(this.uploaded, filesUploadResult.uploaded);
    }

    public int hashCode() {
        return Objects.hash(this.errors, this.uploaded);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilesUploadResult {\n");
        sb.append("    errors: ").append(this.toIndentedString(this.getErrors())).append("\n");
        sb.append("    uploaded: ").append(this.toIndentedString(this.getUploaded())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

