/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.Position;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Footnote base class.")
public abstract class FootnoteBase
implements ModelIfc {
    @SerializedName(value="Position")
    protected Position position = null;
    @SerializedName(value="FootnoteType")
    protected FootnoteTypeEnum footnoteType = null;
    @SerializedName(value="ReferenceMark")
    protected String referenceMark = null;
    @SerializedName(value="Text")
    protected String text = null;

    @ApiModelProperty(value="Gets or sets the link to range start node.")
    public Position getPosition() {
        return this.position;
    }

    public FootnoteBase position(Position position) {
        this.position = position;
        return this;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    @ApiModelProperty(value="Gets or sets the option, that specifies whether this is a footnote or endnote.")
    public FootnoteTypeEnum getFootnoteType() {
        return this.footnoteType;
    }

    public FootnoteBase footnoteType(FootnoteTypeEnum footnoteType) {
        this.footnoteType = footnoteType;
        return this;
    }

    public void setFootnoteType(FootnoteTypeEnum footnoteType) {
        this.footnoteType = footnoteType;
    }

    @ApiModelProperty(value="Gets or sets the custom reference mark to be used for this footnote. The default value is Empty, meaning auto-numbered footnotes are used. RTF-format can only store 1 symbol as custom reference mark, so upon export only the first symbol will be written others will be discard.")
    public String getReferenceMark() {
        return this.referenceMark;
    }

    public FootnoteBase referenceMark(String referenceMark) {
        this.referenceMark = referenceMark;
        return this;
    }

    public void setReferenceMark(String referenceMark) {
        this.referenceMark = referenceMark;
    }

    @ApiModelProperty(value="Gets or sets text of the footnote. This method allows to quickly set text of a footnote from a string. The string can contain paragraph breaks, this will create paragraphs of text in the footnote accordingly.")
    public String getText() {
        return this.text;
    }

    public FootnoteBase text(String text) {
        this.text = text;
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.position != null) {
            this.position.validate();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FootnoteBase footnoteBase = (FootnoteBase)o;
        return Objects.equals(this.position, footnoteBase.position) && Objects.equals((Object)this.footnoteType, (Object)footnoteBase.footnoteType) && Objects.equals(this.referenceMark, footnoteBase.referenceMark) && Objects.equals(this.text, footnoteBase.text);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.position, this.footnoteType, this.referenceMark, this.text});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FootnoteBase {\n");
        sb.append("    position: ").append(this.toIndentedString(this.getPosition())).append("\n");
        sb.append("    footnoteType: ").append(this.toIndentedString((Object)this.getFootnoteType())).append("\n");
        sb.append("    referenceMark: ").append(this.toIndentedString(this.getReferenceMark())).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.getText())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FootnoteTypeEnum {
        FOOTNOTE("Footnote"),
        ENDNOTE("Endnote");

        private String value;

        private FootnoteTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FootnoteTypeEnum fromValue(String text) {
            for (FootnoteTypeEnum b : FootnoteTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FootnoteTypeEnum> {
            public void write(JsonWriter jsonWriter, FootnoteTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FootnoteTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FootnoteTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

