/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container for the footnotes statistical data.")
public class FootnotesStatData
implements ModelIfc {
    @SerializedName(value="ParagraphCount")
    protected Integer paragraphCount = null;
    @SerializedName(value="WordCount")
    protected Integer wordCount = null;

    @ApiModelProperty(value="Gets or sets the total count of paragraphs in footnotes.")
    public Integer getParagraphCount() {
        return this.paragraphCount;
    }

    public FootnotesStatData paragraphCount(Integer paragraphCount) {
        this.paragraphCount = paragraphCount;
        return this;
    }

    public void setParagraphCount(Integer paragraphCount) {
        this.paragraphCount = paragraphCount;
    }

    @ApiModelProperty(value="Gets or sets the total count of words in footnotes.")
    public Integer getWordCount() {
        return this.wordCount;
    }

    public FootnotesStatData wordCount(Integer wordCount) {
        this.wordCount = wordCount;
        return this;
    }

    public void setWordCount(Integer wordCount) {
        this.wordCount = wordCount;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.paragraphCount == null) {
            throw new ApiException(400, "Property ParagraphCount in FootnotesStatData is required.");
        }
        if (this.wordCount == null) {
            throw new ApiException(400, "Property WordCount in FootnotesStatData is required.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FootnotesStatData footnotesStatData = (FootnotesStatData)o;
        return Objects.equals(this.paragraphCount, footnotesStatData.paragraphCount) && Objects.equals(this.wordCount, footnotesStatData.wordCount);
    }

    public int hashCode() {
        return Objects.hash(this.paragraphCount, this.wordCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FootnotesStatData {\n");
        sb.append("    paragraphCount: ").append(this.toIndentedString(this.getParagraphCount())).append("\n");
        sb.append("    wordCount: ").append(this.toIndentedString(this.getWordCount())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

