/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.FormField;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="FormField dropdownlist element.")
public class FormFieldDropDown
extends FormField {
    @SerializedName(value="DropDownItems")
    protected List<String> dropDownItems = null;
    @SerializedName(value="DropDownSelectedIndex")
    protected Integer dropDownSelectedIndex = null;

    @ApiModelProperty(value="Gets or sets the items array of a dropdown form field. Microsoft Word allows maximum 25 items in a dropdown form field.")
    public List<String> getDropDownItems() {
        return this.dropDownItems;
    }

    public FormFieldDropDown dropDownItems(List<String> dropDownItems) {
        this.dropDownItems = dropDownItems;
        return this;
    }

    public FormFieldDropDown addDropDownItemsItem(String dropDownItemsItem) {
        if (this.dropDownItems == null) {
            this.dropDownItems = new ArrayList<String>();
        }
        this.dropDownItems.add(dropDownItemsItem);
        return this;
    }

    public void setDropDownItems(List<String> dropDownItems) {
        this.dropDownItems = dropDownItems;
    }

    @ApiModelProperty(value="Gets or sets the index specifying the currently selected item in a dropdown form field.")
    public Integer getDropDownSelectedIndex() {
        return this.dropDownSelectedIndex;
    }

    public FormFieldDropDown dropDownSelectedIndex(Integer dropDownSelectedIndex) {
        this.dropDownSelectedIndex = dropDownSelectedIndex;
        return this;
    }

    public void setDropDownSelectedIndex(Integer dropDownSelectedIndex) {
        this.dropDownSelectedIndex = dropDownSelectedIndex;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.dropDownItems == null) {
            throw new ApiException(400, "Property DropDownItems in FormFieldDropDown is required.");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormFieldDropDown formFieldDropDown = (FormFieldDropDown)o;
        return Objects.equals(this.dropDownItems, formFieldDropDown.dropDownItems) && Objects.equals(this.dropDownSelectedIndex, formFieldDropDown.dropDownSelectedIndex) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dropDownItems, this.dropDownSelectedIndex, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormFieldDropDown {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.getNodeId())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.getName())).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.getEnabled())).append("\n");
        sb.append("    statusText: ").append(this.toIndentedString(this.getStatusText())).append("\n");
        sb.append("    ownStatus: ").append(this.toIndentedString(this.getOwnStatus())).append("\n");
        sb.append("    helpText: ").append(this.toIndentedString(this.getHelpText())).append("\n");
        sb.append("    ownHelp: ").append(this.toIndentedString(this.getOwnHelp())).append("\n");
        sb.append("    calculateOnExit: ").append(this.toIndentedString(this.getCalculateOnExit())).append("\n");
        sb.append("    entryMacro: ").append(this.toIndentedString(this.getEntryMacro())).append("\n");
        sb.append("    exitMacro: ").append(this.toIndentedString(this.getExitMacro())).append("\n");
        sb.append("    dropDownItems: ").append(this.toIndentedString(this.getDropDownItems())).append("\n");
        sb.append("    dropDownSelectedIndex: ").append(this.toIndentedString(this.getDropDownSelectedIndex())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

