/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.FormField;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="FormField text input element.")
public class FormFieldTextInput
extends FormField {
    @SerializedName(value="TextInputFormat")
    protected String textInputFormat = null;
    @SerializedName(value="TextInputType")
    protected TextInputTypeEnum textInputType = null;
    @SerializedName(value="TextInputDefault")
    protected String textInputDefault = null;
    @SerializedName(value="MaxLength")
    protected Integer maxLength = null;

    @ApiModelProperty(value="Gets or sets text formatting for the text form field. If the text form field contains regular text, then valid format strings are \"\", \"UPPERCASE\", \"LOWERCASE\", \"FIRST CAPITAL\" and \"TITLE CASE\". The strings are case-insensitive.If the text form field contains a number or a date/time value, then valid format strings are number or date and time format strings.")
    public String getTextInputFormat() {
        return this.textInputFormat;
    }

    public FormFieldTextInput textInputFormat(String textInputFormat) {
        this.textInputFormat = textInputFormat;
        return this;
    }

    public void setTextInputFormat(String textInputFormat) {
        this.textInputFormat = textInputFormat;
    }

    @ApiModelProperty(value="Gets or sets the type of the text form field.")
    public TextInputTypeEnum getTextInputType() {
        return this.textInputType;
    }

    public FormFieldTextInput textInputType(TextInputTypeEnum textInputType) {
        this.textInputType = textInputType;
        return this;
    }

    public void setTextInputType(TextInputTypeEnum textInputType) {
        this.textInputType = textInputType;
    }

    @ApiModelProperty(value="Gets or sets the default string or a calculation expression of the text form field. The meaning of this property depends on the value of the TextInputType property.When TextInputType is Regular or Number, this string specifies the default string for the text form field. This string is the content that Microsoft Word will display in the document when the form field is empty.When TextInputType is Calculated, then this string holds the expression to be calculated. The expression needs to be a formula valid according to Microsoft Word formula field requirements. When you set a new expression using this property, Aspose.Words calculates the formula result automatically and inserts it into the form field.")
    public String getTextInputDefault() {
        return this.textInputDefault;
    }

    public FormFieldTextInput textInputDefault(String textInputDefault) {
        this.textInputDefault = textInputDefault;
        return this;
    }

    public void setTextInputDefault(String textInputDefault) {
        this.textInputDefault = textInputDefault;
    }

    @ApiModelProperty(value="Gets or sets the maximum length for the text field. Zero when the length is not limited.")
    public Integer getMaxLength() {
        return this.maxLength;
    }

    public FormFieldTextInput maxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.textInputFormat == null) {
            throw new ApiException(400, "Property TextInputFormat in FormFieldTextInput is required.");
        }
        if (this.textInputDefault == null) {
            throw new ApiException(400, "Property TextInputDefault in FormFieldTextInput is required.");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormFieldTextInput formFieldTextInput = (FormFieldTextInput)o;
        return Objects.equals(this.textInputFormat, formFieldTextInput.textInputFormat) && Objects.equals((Object)this.textInputType, (Object)formFieldTextInput.textInputType) && Objects.equals(this.textInputDefault, formFieldTextInput.textInputDefault) && Objects.equals(this.maxLength, formFieldTextInput.maxLength) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.textInputFormat, this.textInputType, this.textInputDefault, this.maxLength, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormFieldTextInput {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    nodeId: ").append(this.toIndentedString(this.getNodeId())).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.getName())).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.getEnabled())).append("\n");
        sb.append("    statusText: ").append(this.toIndentedString(this.getStatusText())).append("\n");
        sb.append("    ownStatus: ").append(this.toIndentedString(this.getOwnStatus())).append("\n");
        sb.append("    helpText: ").append(this.toIndentedString(this.getHelpText())).append("\n");
        sb.append("    ownHelp: ").append(this.toIndentedString(this.getOwnHelp())).append("\n");
        sb.append("    calculateOnExit: ").append(this.toIndentedString(this.getCalculateOnExit())).append("\n");
        sb.append("    entryMacro: ").append(this.toIndentedString(this.getEntryMacro())).append("\n");
        sb.append("    exitMacro: ").append(this.toIndentedString(this.getExitMacro())).append("\n");
        sb.append("    textInputFormat: ").append(this.toIndentedString(this.getTextInputFormat())).append("\n");
        sb.append("    textInputType: ").append(this.toIndentedString((Object)this.getTextInputType())).append("\n");
        sb.append("    textInputDefault: ").append(this.toIndentedString(this.getTextInputDefault())).append("\n");
        sb.append("    maxLength: ").append(this.toIndentedString(this.getMaxLength())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TextInputTypeEnum {
        REGULAR("Regular"),
        NUMBER("Number"),
        DATE("Date"),
        CURRENTDATE("CurrentDate"),
        CURRENTTIME("CurrentTime"),
        CALCULATED("Calculated");

        private String value;

        private TextInputTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TextInputTypeEnum fromValue(String text) {
            for (TextInputTypeEnum b : TextInputTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TextInputTypeEnum> {
            public void write(JsonWriter jsonWriter, TextInputTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TextInputTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TextInputTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

