/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.HeaderFooterLink;
import com.aspose.words.cloud.model.LinkElement;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.NodeLink;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with a section element.")
public class HeaderFooter
extends HeaderFooterLink {
    @SerializedName(value="ChildNodes")
    protected List<NodeLink> childNodes = null;
    @SerializedName(value="Paragraphs")
    protected LinkElement paragraphs = null;
    @SerializedName(value="DrawingObjects")
    protected LinkElement drawingObjects = null;

    @ApiModelProperty(value="Gets or sets the child nodes.")
    public List<NodeLink> getChildNodes() {
        return this.childNodes;
    }

    public HeaderFooter childNodes(List<NodeLink> childNodes) {
        this.childNodes = childNodes;
        return this;
    }

    public HeaderFooter addChildNodesItem(NodeLink childNodesItem) {
        if (this.childNodes == null) {
            this.childNodes = new ArrayList<NodeLink>();
        }
        this.childNodes.add(childNodesItem);
        return this;
    }

    public void setChildNodes(List<NodeLink> childNodes) {
        this.childNodes = childNodes;
    }

    @ApiModelProperty(value="Gets or sets the link to Paragraphs resource.")
    public LinkElement getParagraphs() {
        return this.paragraphs;
    }

    public HeaderFooter paragraphs(LinkElement paragraphs) {
        this.paragraphs = paragraphs;
        return this;
    }

    public void setParagraphs(LinkElement paragraphs) {
        this.paragraphs = paragraphs;
    }

    @ApiModelProperty(value="Gets or sets the link to DrawingObjects resource.")
    public LinkElement getDrawingObjects() {
        return this.drawingObjects;
    }

    public HeaderFooter drawingObjects(LinkElement drawingObjects) {
        this.drawingObjects = drawingObjects;
        return this;
    }

    public void setDrawingObjects(LinkElement drawingObjects) {
        this.drawingObjects = drawingObjects;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.childNodes != null) {
            for (ModelIfc modelIfc : this.childNodes) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
        if (this.paragraphs != null) {
            this.paragraphs.validate();
        }
        if (this.drawingObjects != null) {
            this.drawingObjects.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeaderFooter headerFooter = (HeaderFooter)o;
        return Objects.equals(this.childNodes, headerFooter.childNodes) && Objects.equals(this.paragraphs, headerFooter.paragraphs) && Objects.equals(this.drawingObjects, headerFooter.drawingObjects) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.childNodes, this.paragraphs, this.drawingObjects, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HeaderFooter {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.getType())).append("\n");
        sb.append("    childNodes: ").append(this.toIndentedString(this.getChildNodes())).append("\n");
        sb.append("    paragraphs: ").append(this.toIndentedString(this.getParagraphs())).append("\n");
        sb.append("    drawingObjects: ").append(this.toIndentedString(this.getDrawingObjects())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

