/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.FixedPageSaveOptionsData;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container abstract class for image save options.")
public abstract class ImageSaveOptionsData
extends FixedPageSaveOptionsData {
    @SerializedName(value="HorizontalResolution")
    protected Double horizontalResolution = null;
    @SerializedName(value="ImageBrightness")
    protected Double imageBrightness = null;
    @SerializedName(value="ImageColorMode")
    protected ImageColorModeEnum imageColorMode = null;
    @SerializedName(value="ImageContrast")
    protected Double imageContrast = null;
    @SerializedName(value="PaperColor")
    protected String paperColor = null;
    @SerializedName(value="PixelFormat")
    protected PixelFormatEnum pixelFormat = null;
    @SerializedName(value="Resolution")
    protected Double resolution = null;
    @SerializedName(value="Scale")
    protected Double scale = null;
    @SerializedName(value="UseAntiAliasing")
    protected Boolean useAntiAliasing = null;
    @SerializedName(value="UseHighQualityRendering")
    protected Boolean useHighQualityRendering = null;
    @SerializedName(value="VerticalResolution")
    protected Double verticalResolution = null;
    @SerializedName(value="ImageHeight")
    protected Integer imageHeight = null;
    @SerializedName(value="ImageWidth")
    protected Integer imageWidth = null;
    @SerializedName(value="UseGdiEmfRenderer")
    protected Boolean useGdiEmfRenderer = null;

    @ApiModelProperty(value="Gets or sets the horizontal resolution in dots per inch for the generated images. This property has effect only when saving to raster image formats. The default value is 96.")
    public Double getHorizontalResolution() {
        return this.horizontalResolution;
    }

    public ImageSaveOptionsData horizontalResolution(Double horizontalResolution) {
        this.horizontalResolution = horizontalResolution;
        return this;
    }

    public void setHorizontalResolution(Double horizontalResolution) {
        this.horizontalResolution = horizontalResolution;
    }

    @ApiModelProperty(value="Gets or sets the brightness level of the image.")
    public Double getImageBrightness() {
        return this.imageBrightness;
    }

    public ImageSaveOptionsData imageBrightness(Double imageBrightness) {
        this.imageBrightness = imageBrightness;
        return this;
    }

    public void setImageBrightness(Double imageBrightness) {
        this.imageBrightness = imageBrightness;
    }

    @ApiModelProperty(value="Gets or sets the color mode of the image.")
    public ImageColorModeEnum getImageColorMode() {
        return this.imageColorMode;
    }

    public ImageSaveOptionsData imageColorMode(ImageColorModeEnum imageColorMode) {
        this.imageColorMode = imageColorMode;
        return this;
    }

    public void setImageColorMode(ImageColorModeEnum imageColorMode) {
        this.imageColorMode = imageColorMode;
    }

    @ApiModelProperty(value="Gets or sets the contrast level of the image.")
    public Double getImageContrast() {
        return this.imageContrast;
    }

    public ImageSaveOptionsData imageContrast(Double imageContrast) {
        this.imageContrast = imageContrast;
        return this;
    }

    public void setImageContrast(Double imageContrast) {
        this.imageContrast = imageContrast;
    }

    @ApiModelProperty(value="Gets or sets the background (paper) color of the image.")
    public String getPaperColor() {
        return this.paperColor;
    }

    public ImageSaveOptionsData paperColor(String paperColor) {
        this.paperColor = paperColor;
        return this;
    }

    public void setPaperColor(String paperColor) {
        this.paperColor = paperColor;
    }

    @ApiModelProperty(value="Gets or sets the pixel format of the image.")
    public PixelFormatEnum getPixelFormat() {
        return this.pixelFormat;
    }

    public ImageSaveOptionsData pixelFormat(PixelFormatEnum pixelFormat) {
        this.pixelFormat = pixelFormat;
        return this;
    }

    public void setPixelFormat(PixelFormatEnum pixelFormat) {
        this.pixelFormat = pixelFormat;
    }

    @ApiModelProperty(value="Gets or sets both horizontal and vertical resolution in dots per inch for the generated images. This property has effect only when saving to raster image formats. The default value is 96.")
    public Double getResolution() {
        return this.resolution;
    }

    public ImageSaveOptionsData resolution(Double resolution) {
        this.resolution = resolution;
        return this;
    }

    public void setResolution(Double resolution) {
        this.resolution = resolution;
    }

    @ApiModelProperty(value="Gets or sets the zoom factor of the image.")
    public Double getScale() {
        return this.scale;
    }

    public ImageSaveOptionsData scale(Double scale) {
        this.scale = scale;
        return this;
    }

    public void setScale(Double scale) {
        this.scale = scale;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to use anti-aliasing for rendering.")
    public Boolean getUseAntiAliasing() {
        return this.useAntiAliasing;
    }

    public ImageSaveOptionsData useAntiAliasing(Boolean useAntiAliasing) {
        this.useAntiAliasing = useAntiAliasing;
        return this;
    }

    public void setUseAntiAliasing(Boolean useAntiAliasing) {
        this.useAntiAliasing = useAntiAliasing;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to use high quality (i.e. slow) rendering algorithms.")
    public Boolean getUseHighQualityRendering() {
        return this.useHighQualityRendering;
    }

    public ImageSaveOptionsData useHighQualityRendering(Boolean useHighQualityRendering) {
        this.useHighQualityRendering = useHighQualityRendering;
        return this;
    }

    public void setUseHighQualityRendering(Boolean useHighQualityRendering) {
        this.useHighQualityRendering = useHighQualityRendering;
    }

    @ApiModelProperty(value="Gets or sets the vertical resolution in dots per inch for the generated images. This property has effect only when saving to raster image formats. The default value is 96.")
    public Double getVerticalResolution() {
        return this.verticalResolution;
    }

    public ImageSaveOptionsData verticalResolution(Double verticalResolution) {
        this.verticalResolution = verticalResolution;
        return this;
    }

    public void setVerticalResolution(Double verticalResolution) {
        this.verticalResolution = verticalResolution;
    }

    @ApiModelProperty(value="Gets or sets the height of a generated image in pixels. This property has effect only when saving to raster image formats and used in pair with ImageWidth.")
    public Integer getImageHeight() {
        return this.imageHeight;
    }

    public ImageSaveOptionsData imageHeight(Integer imageHeight) {
        this.imageHeight = imageHeight;
        return this;
    }

    public void setImageHeight(Integer imageHeight) {
        this.imageHeight = imageHeight;
    }

    @ApiModelProperty(value="Gets or sets the width of a generated image in pixels. This property has effect only when saving to raster image formats and used in pair with ImageHeight.")
    public Integer getImageWidth() {
        return this.imageWidth;
    }

    public ImageSaveOptionsData imageWidth(Integer imageWidth) {
        this.imageWidth = imageWidth;
        return this;
    }

    public void setImageWidth(Integer imageWidth) {
        this.imageWidth = imageWidth;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to use GDI+ or Aspose.Words metafile renderer when saving to EMF. If set to true - GDI+ metafile renderer is used. I.e. content is written to GDI+ graphics object and saved to metafile.If set to false - Aspose.Words metafile renderer is used. I.e. content is written directly to the metafile format with Aspose.Words.The default value is true.Has effect only when saving to EMF.")
    public Boolean getUseGdiEmfRenderer() {
        return this.useGdiEmfRenderer;
    }

    public ImageSaveOptionsData useGdiEmfRenderer(Boolean useGdiEmfRenderer) {
        this.useGdiEmfRenderer = useGdiEmfRenderer;
        return this;
    }

    public void setUseGdiEmfRenderer(Boolean useGdiEmfRenderer) {
        this.useGdiEmfRenderer = useGdiEmfRenderer;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageSaveOptionsData imageSaveOptionsData = (ImageSaveOptionsData)o;
        return Objects.equals(this.horizontalResolution, imageSaveOptionsData.horizontalResolution) && Objects.equals(this.imageBrightness, imageSaveOptionsData.imageBrightness) && Objects.equals((Object)this.imageColorMode, (Object)imageSaveOptionsData.imageColorMode) && Objects.equals(this.imageContrast, imageSaveOptionsData.imageContrast) && Objects.equals(this.paperColor, imageSaveOptionsData.paperColor) && Objects.equals((Object)this.pixelFormat, (Object)imageSaveOptionsData.pixelFormat) && Objects.equals(this.resolution, imageSaveOptionsData.resolution) && Objects.equals(this.scale, imageSaveOptionsData.scale) && Objects.equals(this.useAntiAliasing, imageSaveOptionsData.useAntiAliasing) && Objects.equals(this.useHighQualityRendering, imageSaveOptionsData.useHighQualityRendering) && Objects.equals(this.verticalResolution, imageSaveOptionsData.verticalResolution) && Objects.equals(this.imageHeight, imageSaveOptionsData.imageHeight) && Objects.equals(this.imageWidth, imageSaveOptionsData.imageWidth) && Objects.equals(this.useGdiEmfRenderer, imageSaveOptionsData.useGdiEmfRenderer) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.horizontalResolution, this.imageBrightness, this.imageColorMode, this.imageContrast, this.paperColor, this.pixelFormat, this.resolution, this.scale, this.useAntiAliasing, this.useHighQualityRendering, this.verticalResolution, this.imageHeight, this.imageWidth, this.useGdiEmfRenderer, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageSaveOptionsData {\n");
        sb.append("    allowEmbeddingPostScriptFonts: ").append(this.toIndentedString(this.getAllowEmbeddingPostScriptFonts())).append("\n");
        sb.append("    customTimeZoneInfoData: ").append(this.toIndentedString(this.getCustomTimeZoneInfoData())).append("\n");
        sb.append("    dml3DEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDml3DEffectsRenderingMode())).append("\n");
        sb.append("    dmlEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDmlEffectsRenderingMode())).append("\n");
        sb.append("    dmlRenderingMode: ").append(this.toIndentedString((Object)this.getDmlRenderingMode())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    imlRenderingMode: ").append(this.toIndentedString((Object)this.getImlRenderingMode())).append("\n");
        sb.append("    updateAmbiguousTextFont: ").append(this.toIndentedString(this.getUpdateAmbiguousTextFont())).append("\n");
        sb.append("    updateCreatedTimeProperty: ").append(this.toIndentedString(this.getUpdateCreatedTimeProperty())).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.getUpdateFields())).append("\n");
        sb.append("    updateLastPrintedProperty: ").append(this.toIndentedString(this.getUpdateLastPrintedProperty())).append("\n");
        sb.append("    updateLastSavedTimeProperty: ").append(this.toIndentedString(this.getUpdateLastSavedTimeProperty())).append("\n");
        sb.append("    zipOutput: ").append(this.toIndentedString(this.getZipOutput())).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.getSaveFormat())).append("\n");
        sb.append("    colorMode: ").append(this.toIndentedString((Object)this.getColorMode())).append("\n");
        sb.append("    jpegQuality: ").append(this.toIndentedString(this.getJpegQuality())).append("\n");
        sb.append("    metafileRenderingOptions: ").append(this.toIndentedString(this.getMetafileRenderingOptions())).append("\n");
        sb.append("    numeralFormat: ").append(this.toIndentedString((Object)this.getNumeralFormat())).append("\n");
        sb.append("    optimizeOutput: ").append(this.toIndentedString(this.getOptimizeOutput())).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.getPageCount())).append("\n");
        sb.append("    pageIndex: ").append(this.toIndentedString(this.getPageIndex())).append("\n");
        sb.append("    horizontalResolution: ").append(this.toIndentedString(this.getHorizontalResolution())).append("\n");
        sb.append("    imageBrightness: ").append(this.toIndentedString(this.getImageBrightness())).append("\n");
        sb.append("    imageColorMode: ").append(this.toIndentedString((Object)this.getImageColorMode())).append("\n");
        sb.append("    imageContrast: ").append(this.toIndentedString(this.getImageContrast())).append("\n");
        sb.append("    paperColor: ").append(this.toIndentedString(this.getPaperColor())).append("\n");
        sb.append("    pixelFormat: ").append(this.toIndentedString((Object)this.getPixelFormat())).append("\n");
        sb.append("    resolution: ").append(this.toIndentedString(this.getResolution())).append("\n");
        sb.append("    scale: ").append(this.toIndentedString(this.getScale())).append("\n");
        sb.append("    useAntiAliasing: ").append(this.toIndentedString(this.getUseAntiAliasing())).append("\n");
        sb.append("    useHighQualityRendering: ").append(this.toIndentedString(this.getUseHighQualityRendering())).append("\n");
        sb.append("    verticalResolution: ").append(this.toIndentedString(this.getVerticalResolution())).append("\n");
        sb.append("    imageHeight: ").append(this.toIndentedString(this.getImageHeight())).append("\n");
        sb.append("    imageWidth: ").append(this.toIndentedString(this.getImageWidth())).append("\n");
        sb.append("    useGdiEmfRenderer: ").append(this.toIndentedString(this.getUseGdiEmfRenderer())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ImageColorModeEnum {
        NONE("None"),
        GRAYSCALE("Grayscale"),
        BLACKANDWHITE("BlackAndWhite");

        private String value;

        private ImageColorModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ImageColorModeEnum fromValue(String text) {
            for (ImageColorModeEnum b : ImageColorModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ImageColorModeEnum> {
            public void write(JsonWriter jsonWriter, ImageColorModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ImageColorModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ImageColorModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PixelFormatEnum {
        FORMAT16BPPRGB555("Format16BppRgb555"),
        FORMAT16BPPRGB565("Format16BppRgb565"),
        FORMAT16BPPARGB1555("Format16BppArgb1555"),
        FORMAT24BPPRGB("Format24BppRgb"),
        FORMAT32BPPRGB("Format32BppRgb"),
        FORMAT32BPPARGB("Format32BppArgb"),
        FORMAT32BPPPARGB("Format32BppPArgb"),
        FORMAT48BPPRGB("Format48BppRgb"),
        FORMAT64BPPARGB("Format64BppArgb"),
        FORMAT64BPPPARGB("Format64BppPArgb"),
        FORMAT1BPPINDEXED("Format1bppIndexed");

        private String value;

        private PixelFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PixelFormatEnum fromValue(String text) {
            for (PixelFormatEnum b : PixelFormatEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PixelFormatEnum> {
            public void write(JsonWriter jsonWriter, PixelFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PixelFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PixelFormatEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

