/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents options for parsing JSON data. An instance of this class can be passed into constructors of Aspose.Words.Reporting.JsonDataSource.")
public class JsonDataLoadOptions
implements ModelIfc {
    @SerializedName(value="AlwaysGenerateRootObject")
    protected Boolean alwaysGenerateRootObject = null;
    @SerializedName(value="ExactDateTimeParseFormats")
    protected List<String> exactDateTimeParseFormats = null;
    @SerializedName(value="SimpleValueParseMode")
    protected SimpleValueParseModeEnum simpleValueParseMode = null;

    @ApiModelProperty(value="Gets or sets a value indicating whether a generated data source will always contain an object for a JSON root element. If a JSON root element contains a single complex property, such an object is not created by default. The default value is false.")
    public Boolean getAlwaysGenerateRootObject() {
        return this.alwaysGenerateRootObject;
    }

    public JsonDataLoadOptions alwaysGenerateRootObject(Boolean alwaysGenerateRootObject) {
        this.alwaysGenerateRootObject = alwaysGenerateRootObject;
        return this;
    }

    public void setAlwaysGenerateRootObject(Boolean alwaysGenerateRootObject) {
        this.alwaysGenerateRootObject = alwaysGenerateRootObject;
    }

    @ApiModelProperty(value="Gets or sets exact formats for parsing JSON date-time values while loading JSON. The default is null. Strings encoded using Microsoft\u00ae JSON date-time format (for example, \"/Date(1224043200000)/\") are always recognized as date-time values regardless of a value of this property. The property defines additional formats to be used while parsing date-time values from strings in the following way: \u2022 When Aspose.Words.Reporting.JsonDataLoadOptions.ExactDateTimeParseFormats is null, the ISO-8601 format and all date-time formats supported for the current, English USA, and English New Zealand cultures are used additionally in the mentioned order. \u2022 When Aspose.Words.Reporting.JsonDataLoadOptions.ExactDateTimeParseFormats contains strings, they are used as additional date-time formats utilizing the current culture. \u2022 When Aspose.Words.Reporting.JsonDataLoadOptions.ExactDateTimeParseFormats is empty, no additional date-time formats are used.")
    public List<String> getExactDateTimeParseFormats() {
        return this.exactDateTimeParseFormats;
    }

    public JsonDataLoadOptions exactDateTimeParseFormats(List<String> exactDateTimeParseFormats) {
        this.exactDateTimeParseFormats = exactDateTimeParseFormats;
        return this;
    }

    public JsonDataLoadOptions addExactDateTimeParseFormatsItem(String exactDateTimeParseFormatsItem) {
        if (this.exactDateTimeParseFormats == null) {
            this.exactDateTimeParseFormats = new ArrayList<String>();
        }
        this.exactDateTimeParseFormats.add(exactDateTimeParseFormatsItem);
        return this;
    }

    public void setExactDateTimeParseFormats(List<String> exactDateTimeParseFormats) {
        this.exactDateTimeParseFormats = exactDateTimeParseFormats;
    }

    @ApiModelProperty(value="Gets or sets a mode for parsing JSON simple values (null, boolean, number, integer, and string) while loading JSON. Such a mode does not affect parsing of date-time values. The default is Aspose.Words.Reporting.JsonSimpleValueParseMode.Loose.")
    public SimpleValueParseModeEnum getSimpleValueParseMode() {
        return this.simpleValueParseMode;
    }

    public JsonDataLoadOptions simpleValueParseMode(SimpleValueParseModeEnum simpleValueParseMode) {
        this.simpleValueParseMode = simpleValueParseMode;
        return this;
    }

    public void setSimpleValueParseMode(SimpleValueParseModeEnum simpleValueParseMode) {
        this.simpleValueParseMode = simpleValueParseMode;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.alwaysGenerateRootObject == null) {
            throw new ApiException(400, "Property AlwaysGenerateRootObject in JsonDataLoadOptions is required.");
        }
        if (this.simpleValueParseMode == null) {
            throw new ApiException(400, "Property SimpleValueParseMode in JsonDataLoadOptions is required.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonDataLoadOptions jsonDataLoadOptions = (JsonDataLoadOptions)o;
        return Objects.equals(this.alwaysGenerateRootObject, jsonDataLoadOptions.alwaysGenerateRootObject) && Objects.equals(this.exactDateTimeParseFormats, jsonDataLoadOptions.exactDateTimeParseFormats) && Objects.equals((Object)this.simpleValueParseMode, (Object)jsonDataLoadOptions.simpleValueParseMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alwaysGenerateRootObject, this.exactDateTimeParseFormats, this.simpleValueParseMode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JsonDataLoadOptions {\n");
        sb.append("    alwaysGenerateRootObject: ").append(this.toIndentedString(this.getAlwaysGenerateRootObject())).append("\n");
        sb.append("    exactDateTimeParseFormats: ").append(this.toIndentedString(this.getExactDateTimeParseFormats())).append("\n");
        sb.append("    simpleValueParseMode: ").append(this.toIndentedString((Object)this.getSimpleValueParseMode())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SimpleValueParseModeEnum {
        LOOSE("Loose"),
        STRICT("Strict");

        private String value;

        private SimpleValueParseModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SimpleValueParseModeEnum fromValue(String text) {
            for (SimpleValueParseModeEnum b : SimpleValueParseModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SimpleValueParseModeEnum> {
            public void write(JsonWriter jsonWriter, SimpleValueParseModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SimpleValueParseModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SimpleValueParseModeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

