/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.TxtSaveOptionsBaseData;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for markdown save options.")
public class MarkdownSaveOptionsData
extends TxtSaveOptionsBaseData {
    @SerializedName(value="TableContentAlignment")
    protected TableContentAlignmentEnum tableContentAlignment = null;

    @ApiModelProperty(value="Gets or sets the value, that specifies how to align contents in tables when exporting into the Markdown format. The default value is Auto.")
    public TableContentAlignmentEnum getTableContentAlignment() {
        return this.tableContentAlignment;
    }

    public MarkdownSaveOptionsData tableContentAlignment(TableContentAlignmentEnum tableContentAlignment) {
        this.tableContentAlignment = tableContentAlignment;
        return this;
    }

    public void setTableContentAlignment(TableContentAlignmentEnum tableContentAlignment) {
        this.tableContentAlignment = tableContentAlignment;
    }

    public MarkdownSaveOptionsData() {
        this.saveFormat = "md";
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarkdownSaveOptionsData markdownSaveOptionsData = (MarkdownSaveOptionsData)o;
        return Objects.equals((Object)this.tableContentAlignment, (Object)markdownSaveOptionsData.tableContentAlignment) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.tableContentAlignment, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MarkdownSaveOptionsData {\n");
        sb.append("    allowEmbeddingPostScriptFonts: ").append(this.toIndentedString(this.getAllowEmbeddingPostScriptFonts())).append("\n");
        sb.append("    customTimeZoneInfoData: ").append(this.toIndentedString(this.getCustomTimeZoneInfoData())).append("\n");
        sb.append("    dml3DEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDml3DEffectsRenderingMode())).append("\n");
        sb.append("    dmlEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDmlEffectsRenderingMode())).append("\n");
        sb.append("    dmlRenderingMode: ").append(this.toIndentedString((Object)this.getDmlRenderingMode())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    imlRenderingMode: ").append(this.toIndentedString((Object)this.getImlRenderingMode())).append("\n");
        sb.append("    updateAmbiguousTextFont: ").append(this.toIndentedString(this.getUpdateAmbiguousTextFont())).append("\n");
        sb.append("    updateCreatedTimeProperty: ").append(this.toIndentedString(this.getUpdateCreatedTimeProperty())).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.getUpdateFields())).append("\n");
        sb.append("    updateLastPrintedProperty: ").append(this.toIndentedString(this.getUpdateLastPrintedProperty())).append("\n");
        sb.append("    updateLastSavedTimeProperty: ").append(this.toIndentedString(this.getUpdateLastSavedTimeProperty())).append("\n");
        sb.append("    zipOutput: ").append(this.toIndentedString(this.getZipOutput())).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString(this.getEncoding())).append("\n");
        sb.append("    exportHeadersFootersMode: ").append(this.toIndentedString((Object)this.getExportHeadersFootersMode())).append("\n");
        sb.append("    forcePageBreaks: ").append(this.toIndentedString(this.getForcePageBreaks())).append("\n");
        sb.append("    paragraphBreak: ").append(this.toIndentedString(this.getParagraphBreak())).append("\n");
        sb.append("    tableContentAlignment: ").append(this.toIndentedString((Object)this.getTableContentAlignment())).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.getSaveFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TableContentAlignmentEnum {
        AUTO("Auto"),
        LEFT("Left"),
        CENTER("Center"),
        RIGHT("Right");

        private String value;

        private TableContentAlignmentEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TableContentAlignmentEnum fromValue(String text) {
            for (TableContentAlignmentEnum b : TableContentAlignmentEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TableContentAlignmentEnum> {
            public void write(JsonWriter jsonWriter, TableContentAlignmentEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TableContentAlignmentEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TableContentAlignmentEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

