/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.BookmarksOutlineLevelData;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for outline options.")
public class OutlineOptionsData
implements ModelIfc {
    @SerializedName(value="CreateMissingOutlineLevels")
    protected Boolean createMissingOutlineLevels = null;
    @SerializedName(value="CreateOutlinesForHeadingsInTables")
    protected Boolean createOutlinesForHeadingsInTables = null;
    @SerializedName(value="DefaultBookmarksOutlineLevel")
    protected Integer defaultBookmarksOutlineLevel = null;
    @SerializedName(value="ExpandedOutlineLevels")
    protected Integer expandedOutlineLevels = null;
    @SerializedName(value="HeadingsOutlineLevels")
    protected Integer headingsOutlineLevels = null;
    @SerializedName(value="BookmarksOutlineLevels")
    protected List<BookmarksOutlineLevelData> bookmarksOutlineLevels = null;

    @ApiModelProperty(value="Gets or sets a value indicating whether to create missing outline levels when the document is exported. The default value is false.")
    public Boolean getCreateMissingOutlineLevels() {
        return this.createMissingOutlineLevels;
    }

    public OutlineOptionsData createMissingOutlineLevels(Boolean createMissingOutlineLevels) {
        this.createMissingOutlineLevels = createMissingOutlineLevels;
        return this;
    }

    public void setCreateMissingOutlineLevels(Boolean createMissingOutlineLevels) {
        this.createMissingOutlineLevels = createMissingOutlineLevels;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to create outlines for headings (paragraphs formatted with the Heading styles) inside tables. The default value is false.")
    public Boolean getCreateOutlinesForHeadingsInTables() {
        return this.createOutlinesForHeadingsInTables;
    }

    public OutlineOptionsData createOutlinesForHeadingsInTables(Boolean createOutlinesForHeadingsInTables) {
        this.createOutlinesForHeadingsInTables = createOutlinesForHeadingsInTables;
        return this;
    }

    public void setCreateOutlinesForHeadingsInTables(Boolean createOutlinesForHeadingsInTables) {
        this.createOutlinesForHeadingsInTables = createOutlinesForHeadingsInTables;
    }

    @ApiModelProperty(value="Gets or sets the default level in the document outline at which to display Word bookmarks.")
    public Integer getDefaultBookmarksOutlineLevel() {
        return this.defaultBookmarksOutlineLevel;
    }

    public OutlineOptionsData defaultBookmarksOutlineLevel(Integer defaultBookmarksOutlineLevel) {
        this.defaultBookmarksOutlineLevel = defaultBookmarksOutlineLevel;
        return this;
    }

    public void setDefaultBookmarksOutlineLevel(Integer defaultBookmarksOutlineLevel) {
        this.defaultBookmarksOutlineLevel = defaultBookmarksOutlineLevel;
    }

    @ApiModelProperty(value="Gets or sets the number of levels in the document outline to show expanded when the file is viewed.")
    public Integer getExpandedOutlineLevels() {
        return this.expandedOutlineLevels;
    }

    public OutlineOptionsData expandedOutlineLevels(Integer expandedOutlineLevels) {
        this.expandedOutlineLevels = expandedOutlineLevels;
        return this;
    }

    public void setExpandedOutlineLevels(Integer expandedOutlineLevels) {
        this.expandedOutlineLevels = expandedOutlineLevels;
    }

    @ApiModelProperty(value="Gets or sets the number of levels of headings (paragraphs formatted with the Heading styles) to include in the document outline.")
    public Integer getHeadingsOutlineLevels() {
        return this.headingsOutlineLevels;
    }

    public OutlineOptionsData headingsOutlineLevels(Integer headingsOutlineLevels) {
        this.headingsOutlineLevels = headingsOutlineLevels;
        return this;
    }

    public void setHeadingsOutlineLevels(Integer headingsOutlineLevels) {
        this.headingsOutlineLevels = headingsOutlineLevels;
    }

    @ApiModelProperty(value="Gets or sets the individual bookmarks outline level.")
    public List<BookmarksOutlineLevelData> getBookmarksOutlineLevels() {
        return this.bookmarksOutlineLevels;
    }

    public OutlineOptionsData bookmarksOutlineLevels(List<BookmarksOutlineLevelData> bookmarksOutlineLevels) {
        this.bookmarksOutlineLevels = bookmarksOutlineLevels;
        return this;
    }

    public OutlineOptionsData addBookmarksOutlineLevelsItem(BookmarksOutlineLevelData bookmarksOutlineLevelsItem) {
        if (this.bookmarksOutlineLevels == null) {
            this.bookmarksOutlineLevels = new ArrayList<BookmarksOutlineLevelData>();
        }
        this.bookmarksOutlineLevels.add(bookmarksOutlineLevelsItem);
        return this;
    }

    public void setBookmarksOutlineLevels(List<BookmarksOutlineLevelData> bookmarksOutlineLevels) {
        this.bookmarksOutlineLevels = bookmarksOutlineLevels;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.bookmarksOutlineLevels != null) {
            for (ModelIfc modelIfc : this.bookmarksOutlineLevels) {
                if (modelIfc == null) continue;
                modelIfc.validate();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutlineOptionsData outlineOptionsData = (OutlineOptionsData)o;
        return Objects.equals(this.createMissingOutlineLevels, outlineOptionsData.createMissingOutlineLevels) && Objects.equals(this.createOutlinesForHeadingsInTables, outlineOptionsData.createOutlinesForHeadingsInTables) && Objects.equals(this.defaultBookmarksOutlineLevel, outlineOptionsData.defaultBookmarksOutlineLevel) && Objects.equals(this.expandedOutlineLevels, outlineOptionsData.expandedOutlineLevels) && Objects.equals(this.headingsOutlineLevels, outlineOptionsData.headingsOutlineLevels) && Objects.equals(this.bookmarksOutlineLevels, outlineOptionsData.bookmarksOutlineLevels);
    }

    public int hashCode() {
        return Objects.hash(this.createMissingOutlineLevels, this.createOutlinesForHeadingsInTables, this.defaultBookmarksOutlineLevel, this.expandedOutlineLevels, this.headingsOutlineLevels, this.bookmarksOutlineLevels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OutlineOptionsData {\n");
        sb.append("    createMissingOutlineLevels: ").append(this.toIndentedString(this.getCreateMissingOutlineLevels())).append("\n");
        sb.append("    createOutlinesForHeadingsInTables: ").append(this.toIndentedString(this.getCreateOutlinesForHeadingsInTables())).append("\n");
        sb.append("    defaultBookmarksOutlineLevel: ").append(this.toIndentedString(this.getDefaultBookmarksOutlineLevel())).append("\n");
        sb.append("    expandedOutlineLevels: ").append(this.toIndentedString(this.getExpandedOutlineLevels())).append("\n");
        sb.append("    headingsOutlineLevels: ").append(this.toIndentedString(this.getHeadingsOutlineLevels())).append("\n");
        sb.append("    bookmarksOutlineLevels: ").append(this.toIndentedString(this.getBookmarksOutlineLevels())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

