/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.FootnotesStatData;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container for the page's statistical data.")
public class PageStatData
implements ModelIfc {
    @SerializedName(value="FootnotesStatData")
    protected FootnotesStatData footnotesStatData = null;
    @SerializedName(value="ParagraphCount")
    protected Integer paragraphCount = null;
    @SerializedName(value="WordCount")
    protected Integer wordCount = null;
    @SerializedName(value="PageNumber")
    protected Integer pageNumber = null;

    @ApiModelProperty(value="Gets or sets the detailed statistics on the footnotes.")
    public FootnotesStatData getFootnotesStatData() {
        return this.footnotesStatData;
    }

    public PageStatData footnotesStatData(FootnotesStatData footnotesStatData) {
        this.footnotesStatData = footnotesStatData;
        return this;
    }

    public void setFootnotesStatData(FootnotesStatData footnotesStatData) {
        this.footnotesStatData = footnotesStatData;
    }

    @ApiModelProperty(value="Gets or sets the total count of paragraphs in the page.")
    public Integer getParagraphCount() {
        return this.paragraphCount;
    }

    public PageStatData paragraphCount(Integer paragraphCount) {
        this.paragraphCount = paragraphCount;
        return this;
    }

    public void setParagraphCount(Integer paragraphCount) {
        this.paragraphCount = paragraphCount;
    }

    @ApiModelProperty(value="Gets or sets the total count of words in the page.")
    public Integer getWordCount() {
        return this.wordCount;
    }

    public PageStatData wordCount(Integer wordCount) {
        this.wordCount = wordCount;
        return this;
    }

    public void setWordCount(Integer wordCount) {
        this.wordCount = wordCount;
    }

    @ApiModelProperty(value="Gets or sets the page number.")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public PageStatData pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.paragraphCount == null) {
            throw new ApiException(400, "Property ParagraphCount in PageStatData is required.");
        }
        if (this.wordCount == null) {
            throw new ApiException(400, "Property WordCount in PageStatData is required.");
        }
        if (this.pageNumber == null) {
            throw new ApiException(400, "Property PageNumber in PageStatData is required.");
        }
        if (this.footnotesStatData != null) {
            this.footnotesStatData.validate();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageStatData pageStatData = (PageStatData)o;
        return Objects.equals(this.footnotesStatData, pageStatData.footnotesStatData) && Objects.equals(this.paragraphCount, pageStatData.paragraphCount) && Objects.equals(this.wordCount, pageStatData.wordCount) && Objects.equals(this.pageNumber, pageStatData.pageNumber);
    }

    public int hashCode() {
        return Objects.hash(this.footnotesStatData, this.paragraphCount, this.wordCount, this.pageNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PageStatData {\n");
        sb.append("    footnotesStatData: ").append(this.toIndentedString(this.getFootnotesStatData())).append("\n");
        sb.append("    paragraphCount: ").append(this.toIndentedString(this.getParagraphCount())).append("\n");
        sb.append("    wordCount: ").append(this.toIndentedString(this.getWordCount())).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.getPageNumber())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

