/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ParagraphFormatBase;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Paragraph format element.")
public class ParagraphFormat
extends ParagraphFormatBase {
    @SerializedName(value="IsListItem")
    protected Boolean isListItem = null;
    @SerializedName(value="IsHeading")
    protected Boolean isHeading = null;

    @ApiModelProperty(value="Gets or sets a value indicating whether the paragraph is an item in a bulleted or numbered list.")
    public Boolean getIsListItem() {
        return this.isListItem;
    }

    public ParagraphFormat isListItem(Boolean isListItem) {
        this.isListItem = isListItem;
        return this;
    }

    public void setIsListItem(Boolean isListItem) {
        this.isListItem = isListItem;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the paragraph style is one of the built-in Heading styles.")
    public Boolean getIsHeading() {
        return this.isHeading;
    }

    public ParagraphFormat isHeading(Boolean isHeading) {
        this.isHeading = isHeading;
        return this;
    }

    public void setIsHeading(Boolean isHeading) {
        this.isHeading = isHeading;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParagraphFormat paragraphFormat = (ParagraphFormat)o;
        return Objects.equals(this.isListItem, paragraphFormat.isListItem) && Objects.equals(this.isHeading, paragraphFormat.isHeading) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isListItem, this.isHeading, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ParagraphFormat {\n");
        sb.append("    link: ").append(this.toIndentedString(this.getLink())).append("\n");
        sb.append("    addSpaceBetweenFarEastAndAlpha: ").append(this.toIndentedString(this.getAddSpaceBetweenFarEastAndAlpha())).append("\n");
        sb.append("    addSpaceBetweenFarEastAndDigit: ").append(this.toIndentedString(this.getAddSpaceBetweenFarEastAndDigit())).append("\n");
        sb.append("    alignment: ").append(this.toIndentedString((Object)this.getAlignment())).append("\n");
        sb.append("    bidi: ").append(this.toIndentedString(this.getBidi())).append("\n");
        sb.append("    dropCapPosition: ").append(this.toIndentedString((Object)this.getDropCapPosition())).append("\n");
        sb.append("    firstLineIndent: ").append(this.toIndentedString(this.getFirstLineIndent())).append("\n");
        sb.append("    keepTogether: ").append(this.toIndentedString(this.getKeepTogether())).append("\n");
        sb.append("    keepWithNext: ").append(this.toIndentedString(this.getKeepWithNext())).append("\n");
        sb.append("    leftIndent: ").append(this.toIndentedString(this.getLeftIndent())).append("\n");
        sb.append("    lineSpacing: ").append(this.toIndentedString(this.getLineSpacing())).append("\n");
        sb.append("    lineSpacingRule: ").append(this.toIndentedString((Object)this.getLineSpacingRule())).append("\n");
        sb.append("    linesToDrop: ").append(this.toIndentedString(this.getLinesToDrop())).append("\n");
        sb.append("    noSpaceBetweenParagraphsOfSameStyle: ").append(this.toIndentedString(this.getNoSpaceBetweenParagraphsOfSameStyle())).append("\n");
        sb.append("    outlineLevel: ").append(this.toIndentedString((Object)this.getOutlineLevel())).append("\n");
        sb.append("    pageBreakBefore: ").append(this.toIndentedString(this.getPageBreakBefore())).append("\n");
        sb.append("    rightIndent: ").append(this.toIndentedString(this.getRightIndent())).append("\n");
        sb.append("    spaceAfter: ").append(this.toIndentedString(this.getSpaceAfter())).append("\n");
        sb.append("    spaceAfterAuto: ").append(this.toIndentedString(this.getSpaceAfterAuto())).append("\n");
        sb.append("    spaceBefore: ").append(this.toIndentedString(this.getSpaceBefore())).append("\n");
        sb.append("    spaceBeforeAuto: ").append(this.toIndentedString(this.getSpaceBeforeAuto())).append("\n");
        sb.append("    styleIdentifier: ").append(this.toIndentedString((Object)this.getStyleIdentifier())).append("\n");
        sb.append("    styleName: ").append(this.toIndentedString(this.getStyleName())).append("\n");
        sb.append("    suppressAutoHyphens: ").append(this.toIndentedString(this.getSuppressAutoHyphens())).append("\n");
        sb.append("    suppressLineNumbers: ").append(this.toIndentedString(this.getSuppressLineNumbers())).append("\n");
        sb.append("    widowControl: ").append(this.toIndentedString(this.getWidowControl())).append("\n");
        sb.append("    shading: ").append(this.toIndentedString(this.getShading())).append("\n");
        sb.append("    isListItem: ").append(this.toIndentedString(this.getIsListItem())).append("\n");
        sb.append("    isHeading: ").append(this.toIndentedString(this.getIsHeading())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

