/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.aspose.words.cloud.model.Position;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with a paragraph's text.")
public class ParagraphInsert
implements ModelIfc {
    @SerializedName(value="Text")
    protected String text = null;
    @SerializedName(value="Position")
    protected Position position = null;

    @ApiModelProperty(value="Gets or sets the paragraph's text.")
    public String getText() {
        return this.text;
    }

    public ParagraphInsert text(String text) {
        this.text = text;
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    @ApiModelProperty(value="Gets or sets the position of the node that will be used to determine the placement of a new paragraph.")
    public Position getPosition() {
        return this.position;
    }

    public ParagraphInsert position(Position position) {
        this.position = position;
        return this;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.text == null) {
            throw new ApiException(400, "Property Text in ParagraphInsert is required.");
        }
        if (this.position != null) {
            this.position.validate();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParagraphInsert paragraphInsert = (ParagraphInsert)o;
        return Objects.equals(this.text, paragraphInsert.text) && Objects.equals(this.position, paragraphInsert.position);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.position);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ParagraphInsert {\n");
        sb.append("    text: ").append(this.toIndentedString(this.getText())).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.getPosition())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

