/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Container class for details of digital signature.")
public class PdfDigitalSignatureDetailsData
implements ModelIfc {
    @SerializedName(value="CertificateFilename")
    protected String certificateFilename = null;
    @SerializedName(value="HashAlgorithm")
    protected HashAlgorithmEnum hashAlgorithm = null;
    @SerializedName(value="Location")
    protected String location = null;
    @SerializedName(value="Reason")
    protected String reason = null;
    @SerializedName(value="SignatureDate")
    protected OffsetDateTime signatureDate = null;

    @ApiModelProperty(value="Gets or sets the certificate's filename using for signing.")
    public String getCertificateFilename() {
        return this.certificateFilename;
    }

    public PdfDigitalSignatureDetailsData certificateFilename(String certificateFilename) {
        this.certificateFilename = certificateFilename;
        return this;
    }

    public void setCertificateFilename(String certificateFilename) {
        this.certificateFilename = certificateFilename;
    }

    @ApiModelProperty(value="Gets or sets the hash algorithm.")
    public HashAlgorithmEnum getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public PdfDigitalSignatureDetailsData hashAlgorithm(HashAlgorithmEnum hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
        return this;
    }

    public void setHashAlgorithm(HashAlgorithmEnum hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    @ApiModelProperty(value="Gets or sets the location of the signing.")
    public String getLocation() {
        return this.location;
    }

    public PdfDigitalSignatureDetailsData location(String location) {
        this.location = location;
        return this;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @ApiModelProperty(value="Gets or sets the reason for the signing.")
    public String getReason() {
        return this.reason;
    }

    public PdfDigitalSignatureDetailsData reason(String reason) {
        this.reason = reason;
        return this;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @ApiModelProperty(value="Gets or sets the date of the signing.")
    public OffsetDateTime getSignatureDate() {
        return this.signatureDate;
    }

    public PdfDigitalSignatureDetailsData signatureDate(OffsetDateTime signatureDate) {
        this.signatureDate = signatureDate;
        return this;
    }

    public void setSignatureDate(OffsetDateTime signatureDate) {
        this.signatureDate = signatureDate;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfDigitalSignatureDetailsData pdfDigitalSignatureDetailsData = (PdfDigitalSignatureDetailsData)o;
        return Objects.equals(this.certificateFilename, pdfDigitalSignatureDetailsData.certificateFilename) && Objects.equals((Object)this.hashAlgorithm, (Object)pdfDigitalSignatureDetailsData.hashAlgorithm) && Objects.equals(this.location, pdfDigitalSignatureDetailsData.location) && Objects.equals(this.reason, pdfDigitalSignatureDetailsData.reason) && Objects.equals(this.signatureDate, pdfDigitalSignatureDetailsData.signatureDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.certificateFilename, this.hashAlgorithm, this.location, this.reason, this.signatureDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PdfDigitalSignatureDetailsData {\n");
        sb.append("    certificateFilename: ").append(this.toIndentedString(this.getCertificateFilename())).append("\n");
        sb.append("    hashAlgorithm: ").append(this.toIndentedString((Object)this.getHashAlgorithm())).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.getLocation())).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.getReason())).append("\n");
        sb.append("    signatureDate: ").append(this.toIndentedString(this.getSignatureDate())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum HashAlgorithmEnum {
        SHA256("Sha256"),
        SHA384("Sha384"),
        SHA512("Sha512"),
        RIPEMD160("RipeMD160");

        private String value;

        private HashAlgorithmEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static HashAlgorithmEnum fromValue(String text) {
            for (HashAlgorithmEnum b : HashAlgorithmEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<HashAlgorithmEnum> {
            public void write(JsonWriter jsonWriter, HashAlgorithmEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public HashAlgorithmEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return HashAlgorithmEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

