/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.DownsampleOptionsData;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.FixedPageSaveOptionsData;
import com.aspose.words.cloud.model.OutlineOptionsData;
import com.aspose.words.cloud.model.PdfDigitalSignatureDetailsData;
import com.aspose.words.cloud.model.PdfEncryptionDetailsData;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Container class for pdf save options.")
public class PdfSaveOptionsData
extends FixedPageSaveOptionsData {
    @SerializedName(value="AttachmentsEmbeddingMode")
    protected AttachmentsEmbeddingModeEnum attachmentsEmbeddingMode = null;
    @SerializedName(value="CacheBackgroundGraphics")
    protected Boolean cacheBackgroundGraphics = null;
    @SerializedName(value="Compliance")
    protected ComplianceEnum compliance = null;
    @SerializedName(value="CreateNoteHyperlinks")
    protected Boolean createNoteHyperlinks = null;
    @SerializedName(value="CustomPropertiesExport")
    protected CustomPropertiesExportEnum customPropertiesExport = null;
    @SerializedName(value="DigitalSignatureDetails")
    protected PdfDigitalSignatureDetailsData digitalSignatureDetails = null;
    @SerializedName(value="DisplayDocTitle")
    protected Boolean displayDocTitle = null;
    @SerializedName(value="DownsampleOptions")
    protected DownsampleOptionsData downsampleOptions = null;
    @SerializedName(value="EmbedAttachments")
    protected Boolean embedAttachments = null;
    @SerializedName(value="EmbedFullFonts")
    protected Boolean embedFullFonts = null;
    @SerializedName(value="EncryptionDetails")
    protected PdfEncryptionDetailsData encryptionDetails = null;
    @SerializedName(value="ExportDocumentStructure")
    protected Boolean exportDocumentStructure = null;
    @SerializedName(value="ExportLanguageToSpanTag")
    protected Boolean exportLanguageToSpanTag = null;
    @SerializedName(value="FontEmbeddingMode")
    protected FontEmbeddingModeEnum fontEmbeddingMode = null;
    @SerializedName(value="HeaderFooterBookmarksExportMode")
    protected HeaderFooterBookmarksExportModeEnum headerFooterBookmarksExportMode = null;
    @SerializedName(value="ImageColorSpaceExportMode")
    protected ImageColorSpaceExportModeEnum imageColorSpaceExportMode = null;
    @SerializedName(value="ImageCompression")
    protected String imageCompression = null;
    @SerializedName(value="InterpolateImages")
    protected Boolean interpolateImages = null;
    @SerializedName(value="OpenHyperlinksInNewWindow")
    protected Boolean openHyperlinksInNewWindow = null;
    @SerializedName(value="OutlineOptions")
    protected OutlineOptionsData outlineOptions = null;
    @SerializedName(value="PageMode")
    protected PageModeEnum pageMode = null;
    @SerializedName(value="PreblendImages")
    protected Boolean preblendImages = null;
    @SerializedName(value="PreserveFormFields")
    protected Boolean preserveFormFields = null;
    @SerializedName(value="RenderChoiceFormFieldBorder")
    protected Boolean renderChoiceFormFieldBorder = null;
    @SerializedName(value="TextCompression")
    protected TextCompressionEnum textCompression = null;
    @SerializedName(value="UseBookFoldPrintingSettings")
    protected Boolean useBookFoldPrintingSettings = null;
    @SerializedName(value="UseCoreFonts")
    protected Boolean useCoreFonts = null;
    @SerializedName(value="UseSdtTagAsFormFieldName")
    protected Boolean useSdtTagAsFormFieldName = null;
    @SerializedName(value="ZoomBehavior")
    protected ZoomBehaviorEnum zoomBehavior = null;
    @SerializedName(value="ZoomFactor")
    protected Integer zoomFactor = null;
    @SerializedName(value="ExportFloatingShapesAsInlineTag")
    protected Boolean exportFloatingShapesAsInlineTag = null;

    @ApiModelProperty(value="Gets or sets a value determining how attachments are embedded to the PDF document. The default value is None and attachments are not embedded. PDF/A-1, PDF/A-2 and regular PDF/A-4 (not PDF/A-4f) standards do not allow embedded files. None value will be used automatically.")
    public AttachmentsEmbeddingModeEnum getAttachmentsEmbeddingMode() {
        return this.attachmentsEmbeddingMode;
    }

    public PdfSaveOptionsData attachmentsEmbeddingMode(AttachmentsEmbeddingModeEnum attachmentsEmbeddingMode) {
        this.attachmentsEmbeddingMode = attachmentsEmbeddingMode;
        return this;
    }

    public void setAttachmentsEmbeddingMode(AttachmentsEmbeddingModeEnum attachmentsEmbeddingMode) {
        this.attachmentsEmbeddingMode = attachmentsEmbeddingMode;
    }

    @ApiModelProperty(value="Gets or sets a value determining whether or not to cache graphics placed in document's background. The default value is true and background graphics are written to the PDF document as an xObject. When the value is false background graphics are not cached. Some shapes are not supported for caching(shapes with fields, bookmarks, HRefs). Document background graphic is various shapes, charts, images placed in the footer or header, well as background and border of a page.")
    public Boolean getCacheBackgroundGraphics() {
        return this.cacheBackgroundGraphics;
    }

    public PdfSaveOptionsData cacheBackgroundGraphics(Boolean cacheBackgroundGraphics) {
        this.cacheBackgroundGraphics = cacheBackgroundGraphics;
        return this;
    }

    public void setCacheBackgroundGraphics(Boolean cacheBackgroundGraphics) {
        this.cacheBackgroundGraphics = cacheBackgroundGraphics;
    }

    @ApiModelProperty(value="Gets or sets the PDF standards compliance level for output documents.")
    public ComplianceEnum getCompliance() {
        return this.compliance;
    }

    public PdfSaveOptionsData compliance(ComplianceEnum compliance) {
        this.compliance = compliance;
        return this;
    }

    public void setCompliance(ComplianceEnum compliance) {
        this.compliance = compliance;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to convert footnote/endnote references in main text story into active hyperlinks. When clicked the hyperlink will lead to the corresponding footnote/endnote. The default value is false.")
    public Boolean getCreateNoteHyperlinks() {
        return this.createNoteHyperlinks;
    }

    public PdfSaveOptionsData createNoteHyperlinks(Boolean createNoteHyperlinks) {
        this.createNoteHyperlinks = createNoteHyperlinks;
        return this;
    }

    public void setCreateNoteHyperlinks(Boolean createNoteHyperlinks) {
        this.createNoteHyperlinks = createNoteHyperlinks;
    }

    @ApiModelProperty(value="Gets or sets the option that controls the way CustomDocumentProperties are exported to PDF file. The default value is None.")
    public CustomPropertiesExportEnum getCustomPropertiesExport() {
        return this.customPropertiesExport;
    }

    public PdfSaveOptionsData customPropertiesExport(CustomPropertiesExportEnum customPropertiesExport) {
        this.customPropertiesExport = customPropertiesExport;
        return this;
    }

    public void setCustomPropertiesExport(CustomPropertiesExportEnum customPropertiesExport) {
        this.customPropertiesExport = customPropertiesExport;
    }

    @ApiModelProperty(value="Gets or sets the details for signing the output PDF document.")
    public PdfDigitalSignatureDetailsData getDigitalSignatureDetails() {
        return this.digitalSignatureDetails;
    }

    public PdfSaveOptionsData digitalSignatureDetails(PdfDigitalSignatureDetailsData digitalSignatureDetails) {
        this.digitalSignatureDetails = digitalSignatureDetails;
        return this;
    }

    public void setDigitalSignatureDetails(PdfDigitalSignatureDetailsData digitalSignatureDetails) {
        this.digitalSignatureDetails = digitalSignatureDetails;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the window\u2019s title bar should display the document title taken from the Title entry of the document information dictionary. If false, the title bar should instead display the name of the PDF file containing the document. The default value is false.")
    public Boolean getDisplayDocTitle() {
        return this.displayDocTitle;
    }

    public PdfSaveOptionsData displayDocTitle(Boolean displayDocTitle) {
        this.displayDocTitle = displayDocTitle;
        return this;
    }

    public void setDisplayDocTitle(Boolean displayDocTitle) {
        this.displayDocTitle = displayDocTitle;
    }

    @ApiModelProperty(value="Gets or sets the downsample options.")
    public DownsampleOptionsData getDownsampleOptions() {
        return this.downsampleOptions;
    }

    public PdfSaveOptionsData downsampleOptions(DownsampleOptionsData downsampleOptions) {
        this.downsampleOptions = downsampleOptions;
        return this;
    }

    public void setDownsampleOptions(DownsampleOptionsData downsampleOptions) {
        this.downsampleOptions = downsampleOptions;
    }

    @ApiModelProperty(value="Gets or sets a value determining whether or not to embed attachments to the PDF document. The default value is false and attachments are not embedded. When the value is true attachments are embedded to the PDF document. Embedding attachments is not supported when saving to PDF/A and PDF/UA compliance. false value will be used automatically. Embedding attachments is not supported when encryption is enabled. false value will be used automatically.")
    @Deprecated
    public Boolean getEmbedAttachments() {
        return this.embedAttachments;
    }

    @Deprecated
    public PdfSaveOptionsData embedAttachments(Boolean embedAttachments) {
        this.embedAttachments = embedAttachments;
        return this;
    }

    @Deprecated
    public void setEmbedAttachments(Boolean embedAttachments) {
        this.embedAttachments = embedAttachments;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether fonts are embedded into the resulting PDF documents.")
    public Boolean getEmbedFullFonts() {
        return this.embedFullFonts;
    }

    public PdfSaveOptionsData embedFullFonts(Boolean embedFullFonts) {
        this.embedFullFonts = embedFullFonts;
        return this;
    }

    public void setEmbedFullFonts(Boolean embedFullFonts) {
        this.embedFullFonts = embedFullFonts;
    }

    @ApiModelProperty(value="Gets or sets the details for encrypting the output PDF document.")
    public PdfEncryptionDetailsData getEncryptionDetails() {
        return this.encryptionDetails;
    }

    public PdfSaveOptionsData encryptionDetails(PdfEncryptionDetailsData encryptionDetails) {
        this.encryptionDetails = encryptionDetails;
        return this;
    }

    public void setEncryptionDetails(PdfEncryptionDetailsData encryptionDetails) {
        this.encryptionDetails = encryptionDetails;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to export document structure.")
    public Boolean getExportDocumentStructure() {
        return this.exportDocumentStructure;
    }

    public PdfSaveOptionsData exportDocumentStructure(Boolean exportDocumentStructure) {
        this.exportDocumentStructure = exportDocumentStructure;
        return this;
    }

    public void setExportDocumentStructure(Boolean exportDocumentStructure) {
        this.exportDocumentStructure = exportDocumentStructure;
    }

    @ApiModelProperty(value="Gets or sets a value determining whether or not to create a \"Span\" tag in the document structure to export the text language. The default value is false and \"Lang\" attribute is attached to a marked-content sequence in a page content stream. When the value is true \"Span\" tag is created for the text with non-default language and \"Lang\" attribute is attached to this tag. This value is ignored when Aspose.Words.Saving.PdfSaveOptions.ExportDocumentStructure is false.")
    public Boolean getExportLanguageToSpanTag() {
        return this.exportLanguageToSpanTag;
    }

    public PdfSaveOptionsData exportLanguageToSpanTag(Boolean exportLanguageToSpanTag) {
        this.exportLanguageToSpanTag = exportLanguageToSpanTag;
        return this;
    }

    public void setExportLanguageToSpanTag(Boolean exportLanguageToSpanTag) {
        this.exportLanguageToSpanTag = exportLanguageToSpanTag;
    }

    @ApiModelProperty(value="Gets or sets the font embedding mode.")
    public FontEmbeddingModeEnum getFontEmbeddingMode() {
        return this.fontEmbeddingMode;
    }

    public PdfSaveOptionsData fontEmbeddingMode(FontEmbeddingModeEnum fontEmbeddingMode) {
        this.fontEmbeddingMode = fontEmbeddingMode;
        return this;
    }

    public void setFontEmbeddingMode(FontEmbeddingModeEnum fontEmbeddingMode) {
        this.fontEmbeddingMode = fontEmbeddingMode;
    }

    @ApiModelProperty(value="Gets or sets the option that controls how bookmarks in headers/footers are exported. The default value is Aspose.Words.Saving.HeaderFooterBookmarksExportMode.All.")
    public HeaderFooterBookmarksExportModeEnum getHeaderFooterBookmarksExportMode() {
        return this.headerFooterBookmarksExportMode;
    }

    public PdfSaveOptionsData headerFooterBookmarksExportMode(HeaderFooterBookmarksExportModeEnum headerFooterBookmarksExportMode) {
        this.headerFooterBookmarksExportMode = headerFooterBookmarksExportMode;
        return this;
    }

    public void setHeaderFooterBookmarksExportMode(HeaderFooterBookmarksExportModeEnum headerFooterBookmarksExportMode) {
        this.headerFooterBookmarksExportMode = headerFooterBookmarksExportMode;
    }

    @ApiModelProperty(value="Gets or sets the option that controls how the color space will be selected for the images in PDF document. The default value is \"Auto\". If \"SimpleCmyk\" value is specified, ImageCompression option is ignored and Flate compression is used for all images in the document.")
    public ImageColorSpaceExportModeEnum getImageColorSpaceExportMode() {
        return this.imageColorSpaceExportMode;
    }

    public PdfSaveOptionsData imageColorSpaceExportMode(ImageColorSpaceExportModeEnum imageColorSpaceExportMode) {
        this.imageColorSpaceExportMode = imageColorSpaceExportMode;
        return this;
    }

    public void setImageColorSpaceExportMode(ImageColorSpaceExportModeEnum imageColorSpaceExportMode) {
        this.imageColorSpaceExportMode = imageColorSpaceExportMode;
    }

    @ApiModelProperty(value="Gets or sets the compression type to be used for all images in the document.")
    public String getImageCompression() {
        return this.imageCompression;
    }

    public PdfSaveOptionsData imageCompression(String imageCompression) {
        this.imageCompression = imageCompression;
        return this;
    }

    public void setImageCompression(String imageCompression) {
        this.imageCompression = imageCompression;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether image interpolation shall be performed by a conforming reader. When false is specified, the flag is not written to the output document and the default behavior of reader is used instead. When the resolution of a source image is significantly lower than that of the output device, each source sample covers many device pixels. As a result, images can appear jaggy or blocky. These visual artifacts can be reduced by applying an image interpolation algorithm during rendering. Instead of painting all pixels covered by a source sample with the same color, image interpolation attempts to produce a smooth transition between adjacent sample values. A conforming Reader may choose to not implement this feature of PDF, or may use any specific implementation of interpolation that it wishes. The default value is false.")
    public Boolean getInterpolateImages() {
        return this.interpolateImages;
    }

    public PdfSaveOptionsData interpolateImages(Boolean interpolateImages) {
        this.interpolateImages = interpolateImages;
        return this;
    }

    public void setInterpolateImages(Boolean interpolateImages) {
        this.interpolateImages = interpolateImages;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether hyperlinks in the output Pdf document are forced to be opened in a new window (or tab) of a browser.")
    public Boolean getOpenHyperlinksInNewWindow() {
        return this.openHyperlinksInNewWindow;
    }

    public PdfSaveOptionsData openHyperlinksInNewWindow(Boolean openHyperlinksInNewWindow) {
        this.openHyperlinksInNewWindow = openHyperlinksInNewWindow;
        return this;
    }

    public void setOpenHyperlinksInNewWindow(Boolean openHyperlinksInNewWindow) {
        this.openHyperlinksInNewWindow = openHyperlinksInNewWindow;
    }

    @ApiModelProperty(value="Gets or sets the outline options.")
    public OutlineOptionsData getOutlineOptions() {
        return this.outlineOptions;
    }

    public PdfSaveOptionsData outlineOptions(OutlineOptionsData outlineOptions) {
        this.outlineOptions = outlineOptions;
        return this;
    }

    public void setOutlineOptions(OutlineOptionsData outlineOptions) {
        this.outlineOptions = outlineOptions;
    }

    @ApiModelProperty(value="Gets or sets the option that controls how the PDF document should be displayed when opened in the PDF reader.")
    public PageModeEnum getPageMode() {
        return this.pageMode;
    }

    public PdfSaveOptionsData pageMode(PageModeEnum pageMode) {
        this.pageMode = pageMode;
        return this;
    }

    public void setPageMode(PageModeEnum pageMode) {
        this.pageMode = pageMode;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to preblend transparent images with black background color. Preblending images may improve PDF document visual appearance in Adobe Reader and remove anti-aliasing artifacts.In order to properly display preblended images, PDF viewer application must support /Matte entry in soft-mask image dictionary. Also preblending images may decrease PDF rendering performance.The default value is false.")
    public Boolean getPreblendImages() {
        return this.preblendImages;
    }

    public PdfSaveOptionsData preblendImages(Boolean preblendImages) {
        this.preblendImages = preblendImages;
        return this;
    }

    public void setPreblendImages(Boolean preblendImages) {
        this.preblendImages = preblendImages;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to preserve Microsoft Word form fields as form fields in PDF or convert them to text.")
    public Boolean getPreserveFormFields() {
        return this.preserveFormFields;
    }

    public PdfSaveOptionsData preserveFormFields(Boolean preserveFormFields) {
        this.preserveFormFields = preserveFormFields;
        return this;
    }

    public void setPreserveFormFields(Boolean preserveFormFields) {
        this.preserveFormFields = preserveFormFields;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to render PDF choice form field border. PDF choice form fields are used for export of SDT Combo Box Content Control, SDT Drop-Down List Content Control and legacy Drop-Down Form Field when PreserveFormFields option is enabled.The default value is true.")
    public Boolean getRenderChoiceFormFieldBorder() {
        return this.renderChoiceFormFieldBorder;
    }

    public PdfSaveOptionsData renderChoiceFormFieldBorder(Boolean renderChoiceFormFieldBorder) {
        this.renderChoiceFormFieldBorder = renderChoiceFormFieldBorder;
        return this;
    }

    public void setRenderChoiceFormFieldBorder(Boolean renderChoiceFormFieldBorder) {
        this.renderChoiceFormFieldBorder = renderChoiceFormFieldBorder;
    }

    @ApiModelProperty(value="Gets or sets the compression type to be used for all textual content in the document.")
    public TextCompressionEnum getTextCompression() {
        return this.textCompression;
    }

    public PdfSaveOptionsData textCompression(TextCompressionEnum textCompression) {
        this.textCompression = textCompression;
        return this;
    }

    public void setTextCompression(TextCompressionEnum textCompression) {
        this.textCompression = textCompression;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether the document should be saved using a booklet printing layout.")
    public Boolean getUseBookFoldPrintingSettings() {
        return this.useBookFoldPrintingSettings;
    }

    public PdfSaveOptionsData useBookFoldPrintingSettings(Boolean useBookFoldPrintingSettings) {
        this.useBookFoldPrintingSettings = useBookFoldPrintingSettings;
        return this;
    }

    public void setUseBookFoldPrintingSettings(Boolean useBookFoldPrintingSettings) {
        this.useBookFoldPrintingSettings = useBookFoldPrintingSettings;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to substitute TrueType fonts Arial, Times New Roman, Courier New and Symbol with core PDF Type 1 fonts.")
    public Boolean getUseCoreFonts() {
        return this.useCoreFonts;
    }

    public PdfSaveOptionsData useCoreFonts(Boolean useCoreFonts) {
        this.useCoreFonts = useCoreFonts;
        return this;
    }

    public void setUseCoreFonts(Boolean useCoreFonts) {
        this.useCoreFonts = useCoreFonts;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether to use SDT control Tag or Id property as a name of form field in PDF. The default value is false.When set to false, SDT control Id property is used as a name of form field in PDF.When set to true, SDT control Tag property is used as a name of form field in PDF.If set to true and Tag is empty, Id property will be used as a form field name.If set to true and Tag values are not unique, duplicate Tag values will be altered to build unique PDF form field names.")
    public Boolean getUseSdtTagAsFormFieldName() {
        return this.useSdtTagAsFormFieldName;
    }

    public PdfSaveOptionsData useSdtTagAsFormFieldName(Boolean useSdtTagAsFormFieldName) {
        this.useSdtTagAsFormFieldName = useSdtTagAsFormFieldName;
        return this;
    }

    public void setUseSdtTagAsFormFieldName(Boolean useSdtTagAsFormFieldName) {
        this.useSdtTagAsFormFieldName = useSdtTagAsFormFieldName;
    }

    @ApiModelProperty(value="Gets or sets the option that controls what type of zoom should be applied when a document is opened with a PDF viewer.")
    public ZoomBehaviorEnum getZoomBehavior() {
        return this.zoomBehavior;
    }

    public PdfSaveOptionsData zoomBehavior(ZoomBehaviorEnum zoomBehavior) {
        this.zoomBehavior = zoomBehavior;
        return this;
    }

    public void setZoomBehavior(ZoomBehaviorEnum zoomBehavior) {
        this.zoomBehavior = zoomBehavior;
    }

    @ApiModelProperty(value="Gets or sets the zoom factor (in percentages) for a document.")
    public Integer getZoomFactor() {
        return this.zoomFactor;
    }

    public PdfSaveOptionsData zoomFactor(Integer zoomFactor) {
        this.zoomFactor = zoomFactor;
        return this;
    }

    public void setZoomFactor(Integer zoomFactor) {
        this.zoomFactor = zoomFactor;
    }

    @ApiModelProperty(value="Gets or sets a value determining whether floating shapes are exported as inline tags in the document structure. The default value is false and floating shapes will be exported as block-level tags, placed after the paragraph in which they are anchored. When the value is true floating shapes will be exported as inline tags, placed within the paragraph where they are anchored. This value is ignored when ExportDocumentStructure is false.")
    public Boolean getExportFloatingShapesAsInlineTag() {
        return this.exportFloatingShapesAsInlineTag;
    }

    public PdfSaveOptionsData exportFloatingShapesAsInlineTag(Boolean exportFloatingShapesAsInlineTag) {
        this.exportFloatingShapesAsInlineTag = exportFloatingShapesAsInlineTag;
        return this;
    }

    public void setExportFloatingShapesAsInlineTag(Boolean exportFloatingShapesAsInlineTag) {
        this.exportFloatingShapesAsInlineTag = exportFloatingShapesAsInlineTag;
    }

    public PdfSaveOptionsData() {
        this.saveFormat = "pdf";
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        super.validate();
        if (this.digitalSignatureDetails != null) {
            this.digitalSignatureDetails.validate();
        }
        if (this.downsampleOptions != null) {
            this.downsampleOptions.validate();
        }
        if (this.encryptionDetails != null) {
            this.encryptionDetails.validate();
        }
        if (this.outlineOptions != null) {
            this.outlineOptions.validate();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PdfSaveOptionsData pdfSaveOptionsData = (PdfSaveOptionsData)o;
        return Objects.equals((Object)this.attachmentsEmbeddingMode, (Object)pdfSaveOptionsData.attachmentsEmbeddingMode) && Objects.equals(this.cacheBackgroundGraphics, pdfSaveOptionsData.cacheBackgroundGraphics) && Objects.equals((Object)this.compliance, (Object)pdfSaveOptionsData.compliance) && Objects.equals(this.createNoteHyperlinks, pdfSaveOptionsData.createNoteHyperlinks) && Objects.equals((Object)this.customPropertiesExport, (Object)pdfSaveOptionsData.customPropertiesExport) && Objects.equals(this.digitalSignatureDetails, pdfSaveOptionsData.digitalSignatureDetails) && Objects.equals(this.displayDocTitle, pdfSaveOptionsData.displayDocTitle) && Objects.equals(this.downsampleOptions, pdfSaveOptionsData.downsampleOptions) && Objects.equals(this.embedAttachments, pdfSaveOptionsData.embedAttachments) && Objects.equals(this.embedFullFonts, pdfSaveOptionsData.embedFullFonts) && Objects.equals(this.encryptionDetails, pdfSaveOptionsData.encryptionDetails) && Objects.equals(this.exportDocumentStructure, pdfSaveOptionsData.exportDocumentStructure) && Objects.equals(this.exportLanguageToSpanTag, pdfSaveOptionsData.exportLanguageToSpanTag) && Objects.equals((Object)this.fontEmbeddingMode, (Object)pdfSaveOptionsData.fontEmbeddingMode) && Objects.equals((Object)this.headerFooterBookmarksExportMode, (Object)pdfSaveOptionsData.headerFooterBookmarksExportMode) && Objects.equals((Object)this.imageColorSpaceExportMode, (Object)pdfSaveOptionsData.imageColorSpaceExportMode) && Objects.equals(this.imageCompression, pdfSaveOptionsData.imageCompression) && Objects.equals(this.interpolateImages, pdfSaveOptionsData.interpolateImages) && Objects.equals(this.openHyperlinksInNewWindow, pdfSaveOptionsData.openHyperlinksInNewWindow) && Objects.equals(this.outlineOptions, pdfSaveOptionsData.outlineOptions) && Objects.equals((Object)this.pageMode, (Object)pdfSaveOptionsData.pageMode) && Objects.equals(this.preblendImages, pdfSaveOptionsData.preblendImages) && Objects.equals(this.preserveFormFields, pdfSaveOptionsData.preserveFormFields) && Objects.equals(this.renderChoiceFormFieldBorder, pdfSaveOptionsData.renderChoiceFormFieldBorder) && Objects.equals((Object)this.textCompression, (Object)pdfSaveOptionsData.textCompression) && Objects.equals(this.useBookFoldPrintingSettings, pdfSaveOptionsData.useBookFoldPrintingSettings) && Objects.equals(this.useCoreFonts, pdfSaveOptionsData.useCoreFonts) && Objects.equals(this.useSdtTagAsFormFieldName, pdfSaveOptionsData.useSdtTagAsFormFieldName) && Objects.equals((Object)this.zoomBehavior, (Object)pdfSaveOptionsData.zoomBehavior) && Objects.equals(this.zoomFactor, pdfSaveOptionsData.zoomFactor) && Objects.equals(this.exportFloatingShapesAsInlineTag, pdfSaveOptionsData.exportFloatingShapesAsInlineTag) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.attachmentsEmbeddingMode, this.cacheBackgroundGraphics, this.compliance, this.createNoteHyperlinks, this.customPropertiesExport, this.digitalSignatureDetails, this.displayDocTitle, this.downsampleOptions, this.embedAttachments, this.embedFullFonts, this.encryptionDetails, this.exportDocumentStructure, this.exportLanguageToSpanTag, this.fontEmbeddingMode, this.headerFooterBookmarksExportMode, this.imageColorSpaceExportMode, this.imageCompression, this.interpolateImages, this.openHyperlinksInNewWindow, this.outlineOptions, this.pageMode, this.preblendImages, this.preserveFormFields, this.renderChoiceFormFieldBorder, this.textCompression, this.useBookFoldPrintingSettings, this.useCoreFonts, this.useSdtTagAsFormFieldName, this.zoomBehavior, this.zoomFactor, this.exportFloatingShapesAsInlineTag, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PdfSaveOptionsData {\n");
        sb.append("    allowEmbeddingPostScriptFonts: ").append(this.toIndentedString(this.getAllowEmbeddingPostScriptFonts())).append("\n");
        sb.append("    customTimeZoneInfoData: ").append(this.toIndentedString(this.getCustomTimeZoneInfoData())).append("\n");
        sb.append("    dml3DEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDml3DEffectsRenderingMode())).append("\n");
        sb.append("    dmlEffectsRenderingMode: ").append(this.toIndentedString((Object)this.getDmlEffectsRenderingMode())).append("\n");
        sb.append("    dmlRenderingMode: ").append(this.toIndentedString((Object)this.getDmlRenderingMode())).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.getFileName())).append("\n");
        sb.append("    imlRenderingMode: ").append(this.toIndentedString((Object)this.getImlRenderingMode())).append("\n");
        sb.append("    updateAmbiguousTextFont: ").append(this.toIndentedString(this.getUpdateAmbiguousTextFont())).append("\n");
        sb.append("    updateCreatedTimeProperty: ").append(this.toIndentedString(this.getUpdateCreatedTimeProperty())).append("\n");
        sb.append("    updateFields: ").append(this.toIndentedString(this.getUpdateFields())).append("\n");
        sb.append("    updateLastPrintedProperty: ").append(this.toIndentedString(this.getUpdateLastPrintedProperty())).append("\n");
        sb.append("    updateLastSavedTimeProperty: ").append(this.toIndentedString(this.getUpdateLastSavedTimeProperty())).append("\n");
        sb.append("    zipOutput: ").append(this.toIndentedString(this.getZipOutput())).append("\n");
        sb.append("    colorMode: ").append(this.toIndentedString((Object)this.getColorMode())).append("\n");
        sb.append("    jpegQuality: ").append(this.toIndentedString(this.getJpegQuality())).append("\n");
        sb.append("    metafileRenderingOptions: ").append(this.toIndentedString(this.getMetafileRenderingOptions())).append("\n");
        sb.append("    numeralFormat: ").append(this.toIndentedString((Object)this.getNumeralFormat())).append("\n");
        sb.append("    optimizeOutput: ").append(this.toIndentedString(this.getOptimizeOutput())).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.getPageCount())).append("\n");
        sb.append("    pageIndex: ").append(this.toIndentedString(this.getPageIndex())).append("\n");
        sb.append("    attachmentsEmbeddingMode: ").append(this.toIndentedString((Object)this.getAttachmentsEmbeddingMode())).append("\n");
        sb.append("    cacheBackgroundGraphics: ").append(this.toIndentedString(this.getCacheBackgroundGraphics())).append("\n");
        sb.append("    compliance: ").append(this.toIndentedString((Object)this.getCompliance())).append("\n");
        sb.append("    createNoteHyperlinks: ").append(this.toIndentedString(this.getCreateNoteHyperlinks())).append("\n");
        sb.append("    customPropertiesExport: ").append(this.toIndentedString((Object)this.getCustomPropertiesExport())).append("\n");
        sb.append("    digitalSignatureDetails: ").append(this.toIndentedString(this.getDigitalSignatureDetails())).append("\n");
        sb.append("    displayDocTitle: ").append(this.toIndentedString(this.getDisplayDocTitle())).append("\n");
        sb.append("    downsampleOptions: ").append(this.toIndentedString(this.getDownsampleOptions())).append("\n");
        sb.append("    embedAttachments: ").append(this.toIndentedString(this.getEmbedAttachments())).append("\n");
        sb.append("    embedFullFonts: ").append(this.toIndentedString(this.getEmbedFullFonts())).append("\n");
        sb.append("    encryptionDetails: ").append(this.toIndentedString(this.getEncryptionDetails())).append("\n");
        sb.append("    exportDocumentStructure: ").append(this.toIndentedString(this.getExportDocumentStructure())).append("\n");
        sb.append("    exportLanguageToSpanTag: ").append(this.toIndentedString(this.getExportLanguageToSpanTag())).append("\n");
        sb.append("    fontEmbeddingMode: ").append(this.toIndentedString((Object)this.getFontEmbeddingMode())).append("\n");
        sb.append("    headerFooterBookmarksExportMode: ").append(this.toIndentedString((Object)this.getHeaderFooterBookmarksExportMode())).append("\n");
        sb.append("    imageColorSpaceExportMode: ").append(this.toIndentedString((Object)this.getImageColorSpaceExportMode())).append("\n");
        sb.append("    imageCompression: ").append(this.toIndentedString(this.getImageCompression())).append("\n");
        sb.append("    interpolateImages: ").append(this.toIndentedString(this.getInterpolateImages())).append("\n");
        sb.append("    openHyperlinksInNewWindow: ").append(this.toIndentedString(this.getOpenHyperlinksInNewWindow())).append("\n");
        sb.append("    outlineOptions: ").append(this.toIndentedString(this.getOutlineOptions())).append("\n");
        sb.append("    pageMode: ").append(this.toIndentedString((Object)this.getPageMode())).append("\n");
        sb.append("    preblendImages: ").append(this.toIndentedString(this.getPreblendImages())).append("\n");
        sb.append("    preserveFormFields: ").append(this.toIndentedString(this.getPreserveFormFields())).append("\n");
        sb.append("    renderChoiceFormFieldBorder: ").append(this.toIndentedString(this.getRenderChoiceFormFieldBorder())).append("\n");
        sb.append("    textCompression: ").append(this.toIndentedString((Object)this.getTextCompression())).append("\n");
        sb.append("    useBookFoldPrintingSettings: ").append(this.toIndentedString(this.getUseBookFoldPrintingSettings())).append("\n");
        sb.append("    useCoreFonts: ").append(this.toIndentedString(this.getUseCoreFonts())).append("\n");
        sb.append("    useSdtTagAsFormFieldName: ").append(this.toIndentedString(this.getUseSdtTagAsFormFieldName())).append("\n");
        sb.append("    zoomBehavior: ").append(this.toIndentedString((Object)this.getZoomBehavior())).append("\n");
        sb.append("    zoomFactor: ").append(this.toIndentedString(this.getZoomFactor())).append("\n");
        sb.append("    exportFloatingShapesAsInlineTag: ").append(this.toIndentedString(this.getExportFloatingShapesAsInlineTag())).append("\n");
        sb.append("    saveFormat: ").append(this.toIndentedString(this.getSaveFormat())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AttachmentsEmbeddingModeEnum {
        NONE("None"),
        ANNOTATIONS("Annotations"),
        DOCUMENTEMBEDDEDFILES("DocumentEmbeddedFiles");

        private String value;

        private AttachmentsEmbeddingModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AttachmentsEmbeddingModeEnum fromValue(String text) {
            for (AttachmentsEmbeddingModeEnum b : AttachmentsEmbeddingModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<AttachmentsEmbeddingModeEnum> {
            public void write(JsonWriter jsonWriter, AttachmentsEmbeddingModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AttachmentsEmbeddingModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AttachmentsEmbeddingModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ComplianceEnum {
        PDF17("Pdf17"),
        PDF20("Pdf20"),
        PDFA1A("PdfA1a"),
        PDFA1B("PdfA1b"),
        PDFA2A("PdfA2a"),
        PDFA2U("PdfA2u"),
        PDFA3A("PdfA3a"),
        PDFA3U("PdfA3u"),
        PDFA4("PdfA4"),
        PDFA4F("PdfA4f"),
        PDFA4UA2("PdfA4Ua2"),
        PDFUA1("PdfUa1"),
        PDFUA2("PdfUa2");

        private String value;

        private ComplianceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ComplianceEnum fromValue(String text) {
            for (ComplianceEnum b : ComplianceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ComplianceEnum> {
            public void write(JsonWriter jsonWriter, ComplianceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ComplianceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ComplianceEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CustomPropertiesExportEnum {
        NONE("None"),
        STANDARD("Standard"),
        METADATA("Metadata");

        private String value;

        private CustomPropertiesExportEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CustomPropertiesExportEnum fromValue(String text) {
            for (CustomPropertiesExportEnum b : CustomPropertiesExportEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CustomPropertiesExportEnum> {
            public void write(JsonWriter jsonWriter, CustomPropertiesExportEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CustomPropertiesExportEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CustomPropertiesExportEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FontEmbeddingModeEnum {
        EMBEDALL("EmbedAll"),
        EMBEDNONSTANDARD("EmbedNonstandard"),
        EMBEDNONE("EmbedNone");

        private String value;

        private FontEmbeddingModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FontEmbeddingModeEnum fromValue(String text) {
            for (FontEmbeddingModeEnum b : FontEmbeddingModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<FontEmbeddingModeEnum> {
            public void write(JsonWriter jsonWriter, FontEmbeddingModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FontEmbeddingModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FontEmbeddingModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum HeaderFooterBookmarksExportModeEnum {
        NONE("None"),
        FIRST("First"),
        ALL("All");

        private String value;

        private HeaderFooterBookmarksExportModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static HeaderFooterBookmarksExportModeEnum fromValue(String text) {
            for (HeaderFooterBookmarksExportModeEnum b : HeaderFooterBookmarksExportModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<HeaderFooterBookmarksExportModeEnum> {
            public void write(JsonWriter jsonWriter, HeaderFooterBookmarksExportModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public HeaderFooterBookmarksExportModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return HeaderFooterBookmarksExportModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ImageColorSpaceExportModeEnum {
        AUTO("Auto"),
        SIMPLECMYK("SimpleCmyk");

        private String value;

        private ImageColorSpaceExportModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ImageColorSpaceExportModeEnum fromValue(String text) {
            for (ImageColorSpaceExportModeEnum b : ImageColorSpaceExportModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ImageColorSpaceExportModeEnum> {
            public void write(JsonWriter jsonWriter, ImageColorSpaceExportModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ImageColorSpaceExportModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ImageColorSpaceExportModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PageModeEnum {
        USENONE("UseNone"),
        USEOUTLINES("UseOutlines"),
        USETHUMBS("UseThumbs"),
        FULLSCREEN("FullScreen"),
        USEOC("UseOC"),
        USEATTACHMENTS("UseAttachments");

        private String value;

        private PageModeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PageModeEnum fromValue(String text) {
            for (PageModeEnum b : PageModeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<PageModeEnum> {
            public void write(JsonWriter jsonWriter, PageModeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PageModeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PageModeEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TextCompressionEnum {
        NONE("None"),
        FLATE("Flate");

        private String value;

        private TextCompressionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TextCompressionEnum fromValue(String text) {
            for (TextCompressionEnum b : TextCompressionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TextCompressionEnum> {
            public void write(JsonWriter jsonWriter, TextCompressionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TextCompressionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TextCompressionEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ZoomBehaviorEnum {
        NONE("None"),
        ZOOMFACTOR("ZoomFactor"),
        FITPAGE("FitPage"),
        FITWIDTH("FitWidth"),
        FITHEIGHT("FitHeight"),
        FITBOX("FitBox");

        private String value;

        private ZoomBehaviorEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ZoomBehaviorEnum fromValue(String text) {
            for (ZoomBehaviorEnum b : ZoomBehaviorEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ZoomBehaviorEnum> {
            public void write(JsonWriter jsonWriter, ZoomBehaviorEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ZoomBehaviorEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ZoomBehaviorEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

