/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with a preferred width value.")
public class PreferredWidth
implements ModelIfc {
    @SerializedName(value="Type")
    protected TypeEnum type = null;
    @SerializedName(value="Value")
    protected Double value = null;

    @ApiModelProperty(value="Gets or sets the unit of measure used for this preferred width value.")
    public TypeEnum getType() {
        return this.type;
    }

    public PreferredWidth type(TypeEnum type) {
        this.type = type;
        return this;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    @ApiModelProperty(value="Gets or sets the preferred width value. The unit of measure is specified in the Type property.")
    public Double getValue() {
        return this.value;
    }

    public PreferredWidth value(Double value) {
        this.value = value;
        return this;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.type == null) {
            throw new ApiException(400, "Property Type in PreferredWidth is required.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreferredWidth preferredWidth = (PreferredWidth)o;
        return Objects.equals((Object)this.type, (Object)preferredWidth.type) && Objects.equals(this.value, preferredWidth.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PreferredWidth {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.getType())).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.getValue())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        AUTO("Auto"),
        PERCENT("Percent"),
        POINTS("Points");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

