/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DTO container with a range element.")
public class ReplaceRange
implements ModelIfc {
    @SerializedName(value="Text")
    protected String text = null;
    @SerializedName(value="TextType")
    protected TextTypeEnum textType = null;

    @ApiModelProperty(value="Gets or sets the range's text.")
    public String getText() {
        return this.text;
    }

    public ReplaceRange text(String text) {
        this.text = text;
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    @ApiModelProperty(value="Gets or sets the range's text type.")
    public TextTypeEnum getTextType() {
        return this.textType;
    }

    public ReplaceRange textType(TextTypeEnum textType) {
        this.textType = textType;
        return this;
    }

    public void setTextType(TextTypeEnum textType) {
        this.textType = textType;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.text == null) {
            throw new ApiException(400, "Property Text in ReplaceRange is required.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplaceRange replaceRange = (ReplaceRange)o;
        return Objects.equals(this.text, replaceRange.text) && Objects.equals((Object)this.textType, (Object)replaceRange.textType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.text, this.textType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReplaceRange {\n");
        sb.append("    text: ").append(this.toIndentedString(this.getText())).append("\n");
        sb.append("    textType: ").append(this.toIndentedString((Object)this.getTextType())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TextTypeEnum {
        TEXT("Text"),
        HTML("Html");

        private String value;

        private TextTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TextTypeEnum fromValue(String text) {
            for (TextTypeEnum b : TextTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TextTypeEnum> {
            public void write(JsonWriter jsonWriter, TextTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TextTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TextTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

