/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="Container class for digital signature options.")
public class SignOptions
implements ModelIfc {
    @SerializedName(value="Comments")
    protected String comments = null;
    @SerializedName(value="DecryptionPassword")
    protected String decryptionPassword = null;
    @SerializedName(value="ProviderId")
    protected String providerId = null;
    @SerializedName(value="SignatureLineId")
    protected String signatureLineId = null;
    @SerializedName(value="SignatureLineImageFilename")
    protected String signatureLineImageFilename = null;
    @SerializedName(value="SignTime")
    protected OffsetDateTime signTime = null;

    @ApiModelProperty(value="Gets or sets comments on the digital signature. The default value is an empty string.")
    public String getComments() {
        return this.comments;
    }

    public SignOptions comments(String comments) {
        this.comments = comments;
        return this;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @ApiModelProperty(value="Gets or sets the password to decrypt source document. The default value is an empty string.")
    public String getDecryptionPassword() {
        return this.decryptionPassword;
    }

    public SignOptions decryptionPassword(String decryptionPassword) {
        this.decryptionPassword = decryptionPassword;
        return this;
    }

    public void setDecryptionPassword(String decryptionPassword) {
        this.decryptionPassword = decryptionPassword;
    }

    @ApiModelProperty(value="Gets or sets the class Guid of the signature cryptography provider. The default value is Empty (all zeroes) Guid.")
    public String getProviderId() {
        return this.providerId;
    }

    public SignOptions providerId(String providerId) {
        this.providerId = providerId;
        return this;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    @ApiModelProperty(value="Gets or sets user defined signature line Guid. The default value is Empty (all zeroes) Guid.")
    public String getSignatureLineId() {
        return this.signatureLineId;
    }

    public SignOptions signatureLineId(String signatureLineId) {
        this.signatureLineId = signatureLineId;
        return this;
    }

    public void setSignatureLineId(String signatureLineId) {
        this.signatureLineId = signatureLineId;
    }

    @ApiModelProperty(value="Gets or sets the image that will be shown in associated SignatureLine. The default value is an empty string.")
    public String getSignatureLineImageFilename() {
        return this.signatureLineImageFilename;
    }

    public SignOptions signatureLineImageFilename(String signatureLineImageFilename) {
        this.signatureLineImageFilename = signatureLineImageFilename;
        return this;
    }

    public void setSignatureLineImageFilename(String signatureLineImageFilename) {
        this.signatureLineImageFilename = signatureLineImageFilename;
    }

    @ApiModelProperty(value="Gets or sets the date of signing. The default value is current time (Now).")
    public OffsetDateTime getSignTime() {
        return this.signTime;
    }

    public SignOptions signTime(OffsetDateTime signTime) {
        this.signTime = signTime;
        return this;
    }

    public void setSignTime(OffsetDateTime signTime) {
        this.signTime = signTime;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignOptions signOptions = (SignOptions)o;
        return Objects.equals(this.comments, signOptions.comments) && Objects.equals(this.decryptionPassword, signOptions.decryptionPassword) && Objects.equals(this.providerId, signOptions.providerId) && Objects.equals(this.signatureLineId, signOptions.signatureLineId) && Objects.equals(this.signatureLineImageFilename, signOptions.signatureLineImageFilename) && Objects.equals(this.signTime, signOptions.signTime);
    }

    public int hashCode() {
        return Objects.hash(this.comments, this.decryptionPassword, this.providerId, this.signatureLineId, this.signatureLineImageFilename, this.signTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignOptions {\n");
        sb.append("    comments: ").append(this.toIndentedString(this.getComments())).append("\n");
        sb.append("    decryptionPassword: ").append(this.toIndentedString(this.getDecryptionPassword())).append("\n");
        sb.append("    providerId: ").append(this.toIndentedString(this.getProviderId())).append("\n");
        sb.append("    signatureLineId: ").append(this.toIndentedString(this.getSignatureLineId())).append("\n");
        sb.append("    signatureLineImageFilename: ").append(this.toIndentedString(this.getSignatureLineImageFilename())).append("\n");
        sb.append("    signTime: ").append(this.toIndentedString(this.getSignTime())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

