/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.cloud.model;

import com.aspose.words.cloud.ApiException;
import com.aspose.words.cloud.model.FileReference;
import com.aspose.words.cloud.model.ModelIfc;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@ApiModel(description="The REST response with a document signature collection. This response is returned by the Service when handling any \"https://api.aspose.cloud/v4.0/words/Test.doc/signatures\" REST API requests.")
public class Signature
implements ModelIfc {
    @SerializedName(value="Comments")
    protected String comments = null;
    @SerializedName(value="IssuerName")
    protected String issuerName = null;
    @SerializedName(value="IsValid")
    protected Boolean isValid = null;
    @SerializedName(value="SignatureType")
    protected String signatureType = null;
    @SerializedName(value="SignatureValue")
    protected String signatureValue = null;
    @SerializedName(value="SignTime")
    protected OffsetDateTime signTime = null;
    @SerializedName(value="SubjectName")
    protected String subjectName = null;

    @ApiModelProperty(value="Gets or sets the signing purpose comment.")
    public String getComments() {
        return this.comments;
    }

    public Signature comments(String comments) {
        this.comments = comments;
        return this;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    @ApiModelProperty(value="Gets or sets the subject distinguished name of the certificate issuer.")
    public String getIssuerName() {
        return this.issuerName;
    }

    public Signature issuerName(String issuerName) {
        this.issuerName = issuerName;
        return this;
    }

    public void setIssuerName(String issuerName) {
        this.issuerName = issuerName;
    }

    @ApiModelProperty(value="Gets or sets a value indicating whether this digital signature is valid.")
    public Boolean getIsValid() {
        return this.isValid;
    }

    public Signature isValid(Boolean isValid) {
        this.isValid = isValid;
        return this;
    }

    public void setIsValid(Boolean isValid) {
        this.isValid = isValid;
    }

    @ApiModelProperty(value="Gets or sets the type of the digital signature.")
    public String getSignatureType() {
        return this.signatureType;
    }

    public Signature signatureType(String signatureType) {
        this.signatureType = signatureType;
        return this;
    }

    public void setSignatureType(String signatureType) {
        this.signatureType = signatureType;
    }

    @ApiModelProperty(value="Gets or sets an array of bytes representing a signature value as base64 string.")
    public String getSignatureValue() {
        return this.signatureValue;
    }

    public Signature signatureValue(String signatureValue) {
        this.signatureValue = signatureValue;
        return this;
    }

    public void setSignatureValue(String signatureValue) {
        this.signatureValue = signatureValue;
    }

    @ApiModelProperty(value="Gets or sets the time the document was signed.")
    public OffsetDateTime getSignTime() {
        return this.signTime;
    }

    public Signature signTime(OffsetDateTime signTime) {
        this.signTime = signTime;
        return this;
    }

    public void setSignTime(OffsetDateTime signTime) {
        this.signTime = signTime;
    }

    @ApiModelProperty(value="Gets or sets the subject distinguished name of the certificate that was used to sign the document.")
    public String getSubjectName() {
        return this.subjectName;
    }

    public Signature subjectName(String subjectName) {
        this.subjectName = subjectName;
        return this;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    @Override
    public void getFilesContent(List<FileReference> resultFilesContent) {
    }

    @Override
    public void validate() throws ApiException {
        if (this.isValid == null) {
            throw new ApiException(400, "Property IsValid in Signature is required.");
        }
        if (this.signTime == null) {
            throw new ApiException(400, "Property SignTime in Signature is required.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Signature signature = (Signature)o;
        return Objects.equals(this.comments, signature.comments) && Objects.equals(this.issuerName, signature.issuerName) && Objects.equals(this.isValid, signature.isValid) && Objects.equals(this.signatureType, signature.signatureType) && Objects.equals(this.signatureValue, signature.signatureValue) && Objects.equals(this.signTime, signature.signTime) && Objects.equals(this.subjectName, signature.subjectName);
    }

    public int hashCode() {
        return Objects.hash(this.comments, this.issuerName, this.isValid, this.signatureType, this.signatureValue, this.signTime, this.subjectName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Signature {\n");
        sb.append("    comments: ").append(this.toIndentedString(this.getComments())).append("\n");
        sb.append("    issuerName: ").append(this.toIndentedString(this.getIssuerName())).append("\n");
        sb.append("    isValid: ").append(this.toIndentedString(this.getIsValid())).append("\n");
        sb.append("    signatureType: ").append(this.toIndentedString(this.getSignatureType())).append("\n");
        sb.append("    signatureValue: ").append(this.toIndentedString(this.getSignatureValue())).append("\n");
        sb.append("    signTime: ").append(this.toIndentedString(this.getSignTime())).append("\n");
        sb.append("    subjectName: ").append(this.toIndentedString(this.getSubjectName())).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

